/*
 * Copyright 2008 Department of Mathematical Sciences, New Mexico State University
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * DEPARTMENT OF MATHEMATICAL SCIENCES OR NEW MEXICO STATE UNIVERSITY BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _h_gectrlbmaps
#define _h_gectrlbmaps

static const gchar *copy_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"..............  ",
".            .  ",
". ..............",
". .          . .",
". .          . .",
". .          . .",
". .          . .",
". .          . .",
". .          . .",
". .          . .",
". .          . .",
". .          . .",
". .          . .",
".............. .",
"  .            .",
"  .............."
};

static const gchar *dleft_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"                ",
"        .       ",
"       ...      ",
"      .....     ",
"  .. .......    ",
"  ...........   ",
"  ............  ",
"  ...........   ",
"  ..........    ",
"  .........     ",
"  ........      ",
"  .........     ",
"  .........     ",
"                ",
"                "
};

static const gchar *down_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"                ",
"     ......     ",
"     ......     ",
"     ......     ",
"     ......     ",
" .............. ",
" .............. ",
"  ............  ",
"   ..........   ",
"    ........    ",
"     ......     ",
"      ....      ",
"       ..       ",
"                ",
"                "
};

static const gchar *draw_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"         ...    ",
"         ....   ",
"        .  .    ",
"        .  .    ",
"       .  .     ",
"       .  .     ",
"      .  .      ",
"      .  .      ",
"     .  .       ",
"     .  .       ",
"    .  .        ",
"    .  .        ",
"   .  .         ",
"   .  .         ",
"   ...          ",
"   ..           "
};

static const gchar *dright_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"                ",
"       .        ",
"      ...       ",
"     .....      ",
"    ....... ..  ",
"   ...........  ",
"  ............  ",
"   ...........  ",
"    ..........  ",
"     .........  ",
"      ........  ",
"     .........  ",
"     .........  ",
"                ",
"                "
};

static const gchar *fliph_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"       ..       ",
"       ..       ",
"       ..       ",
" ........ .. .. ",
" .     ..     . ",
" .     ..       ",
" .     ..     . ",
" .     ..     . ",
" .     ..       ",
" .     ..     . ",
" ........ .. .. ",
"       ..       ",
"       ..       ",
"       ..       ",
"                "
};

static const gchar *flipv_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"    ........    ",
"    .      .    ",
"    .      .    ",
"    .      .    ",
"    .      .    ",
"    .      .    ",
" .............. ",
" .............. ",
"                ",
"    .      .    ",
"    .      .    ",
"                ",
"    .      .    ",
"    .. .. ..    ",
"                "
};

static const gchar *left_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"        ..      ",
"       ...      ",
"      ....      ",
"     .....      ",
"    ..........  ",
"   ...........  ",
"  ............  ",
"  ............  ",
"   ...........  ",
"    ..........  ",
"     .....      ",
"      ....      ",
"       ...      ",
"        ..      ",
"                "
};

static const gchar *move_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"..  ..  ..  ..  ",
".            .  ",
"  ..............",
"  .            .",
". .          . .",
". .          . .",
"  .            .",
"  .            .",
". .          . .",
". .          . .",
"  .            .",
"  .            .",
". .          . .",
"... ..  ..  .. .",
"  .            .",
"  .............."
};

static const gchar *right_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"      ..        ",
"      ...       ",
"      ....      ",
"      .....     ",
"  ..........    ",
"  ...........   ",
"  ............  ",
"  ............  ",
"  ...........   ",
"  ..........    ",
"      .....     ",
"      ....      ",
"      ...       ",
"      ..        ",
"                "
};

static const gchar *rleft_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"                ",
"     ..         ",
"    ...         ",
"   ....         ",
"  ............  ",
" .............. ",
" .............. ",
"  ............. ",
"   ....    .... ",
"    ...    .... ",
"     ..    .... ",
"           .... ",
"           .... ",
"                ",
"                "
};

static const gchar *rotate_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"                ",
"     ......     ",
"   ..........   ",
"   ..........   ",
"  ....    ....  ",
"  ...      ...  ",
"  ...      ...  ",
"  ...   .  ...  ",
"  ...   ......  ",
"  ...   ......  ",
"  ....  .....   ",
"   .... .....   ",
"    ... ......  ",
"                ",
"                "
};

static const gchar *rright_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"                ",
"         ..     ",
"         ...    ",
"         ....   ",
"  ............  ",
" .............. ",
" .............. ",
" .............  ",
" ....    ....   ",
" ....    ...    ",
" ....    ..     ",
" ....           ",
" ....           ",
"                ",
"                "
};

static const gchar *shear_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"   .            ",
"   .            ",
"   ....       . ",
"   .   . .   .  ",
"   .    ..  .   ",
"   .   ... .    ",
"   .      .     ",
"   .     .      ",
"   .    .       ",
"   .   .        ",
"   .  .         ",
" .............. ",
"   .            ",
"   .            ",
"                "
};

static const gchar *uleft_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"                ",
"  .........     ",
"  .........     ",
"  ........      ",
"  .........     ",
"  ..........    ",
"  ...........   ",
"  ............  ",
"  ...........   ",
"  .. .......    ",
"      .....     ",
"       ...      ",
"        .       ",
"                ",
"                "
};

static const gchar *up_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"                ",
"       ..       ",
"      ....      ",
"     ......     ",
"    ........    ",
"   ..........   ",
"  ............  ",
" .............. ",
" .............. ",
"     ......     ",
"     ......     ",
"     ......     ",
"     ......     ",
"                ",
"                "
};

static const gchar *uright_xpm[] = {
"16 16 2 1",
"  c None",
". c black",
"                ",
"                ",
"     .........  ",
"     .........  ",
"      ........  ",
"     .........  ",
"    ..........  ",
"   ...........  ",
"  ............  ",
"   ...........  ",
"    ....... ..  ",
"     .....      ",
"      ...       ",
"       .        ",
"                ",
"                "
};

#endif /* _h_gectrlbmaps */
