/*
 * Decompiled with CFR 0.152.
 */
package burp.faraday;

import burp.IBurpExtenderCallbacks;
import burp.IScanIssue;
import burp.ITab;
import burp.faraday.FaradayConnector;
import burp.faraday.VulnerabilityMapper;
import burp.faraday.Workspace;
import burp.faraday.exceptions.CookieExpiredException;
import burp.faraday.exceptions.InvalidCredentialsException;
import burp.faraday.exceptions.InvalidFaradayServerException;
import burp.faraday.exceptions.ObjectNotCreatedException;
import burp.faraday.exceptions.SecondFactorRequiredException;
import burp.faraday.exceptions.ServerTooOldException;
import burp.faraday.models.ExtensionSettings;
import burp.faraday.models.FaradayConnectorStatus;
import burp.faraday.models.vulnerability.Vulnerability;
import java.awt.Component;
import java.awt.Container;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class FaradayExtensionUI
implements ITab {
    private JTextField faradayUrlText;
    private JTextField usernameText;
    private JPasswordField passwordField;
    private JTextField secondFactorField;
    private JButton statusButton;
    private JLabel loginStatusLabel;
    private JPanel tab;
    private PrintWriter stdout;
    private IBurpExtenderCallbacks callbacks;
    private final FaradayConnector faradayConnector;
    private final ExtensionSettings extensionSettings;
    private Component loginPanel;
    private Component settingsPannel;
    private Component otherSettingsPanel;
    private JComboBox<Workspace> workspaceCombo;
    private FaradayConnectorStatus status = FaradayConnectorStatus.DISCONNECTED;

    public FaradayExtensionUI(PrintWriter stdout, IBurpExtenderCallbacks callbacks, FaradayConnector faradayConnector, ExtensionSettings extensionSettings) {
        this.stdout = stdout;
        this.callbacks = callbacks;
        this.faradayConnector = faradayConnector;
        this.extensionSettings = extensionSettings;
        this.tab = new JPanel();
        GroupLayout layout = new GroupLayout(this.tab);
        this.tab.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.loginPanel = this.setupLoginPanel();
        this.settingsPannel = this.setupSettingsPanel();
        this.otherSettingsPanel = this.setupOtherSettingsPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.loginPanel).addComponent(this.settingsPannel).addComponent(this.otherSettingsPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.loginPanel).addComponent(this.settingsPannel).addComponent(this.otherSettingsPanel));
        layout.linkSize(0, this.loginPanel, this.settingsPannel, this.otherSettingsPanel);
        this.disablePanel(this.settingsPannel);
    }

    private Component setupLoginPanel() {
        JPanel loginPanel = new JPanel();
        loginPanel.setBorder(BorderFactory.createTitledBorder("Login to Faraday"));
        JLabel faradayUrlLabel = new JLabel("Faraday Server URL: ");
        this.faradayUrlText = new JTextField();
        this.faradayUrlText.setText(this.extensionSettings.getFaradayURL());
        JLabel usernameLabel = new JLabel("Username: ");
        this.usernameText = new JTextField();
        this.usernameText.setEnabled(false);
        this.usernameText.setText(this.extensionSettings.getUsername());
        JLabel passwordLabel = new JLabel("Password: ");
        this.passwordField = new JPasswordField();
        this.passwordField.setEnabled(false);
        this.passwordField.setText(this.extensionSettings.getPassword());
        JLabel secondFactorLabel = new JLabel("2FA Token: ");
        this.secondFactorField = new JTextField();
        this.secondFactorField.setEnabled(false);
        this.statusButton = new JButton("Connect");
        this.statusButton.addActionListener(actionEvent -> this.onStatusPressed());
        this.loginStatusLabel = new JLabel("Not connected");
        GroupLayout layout = new GroupLayout(loginPanel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        loginPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(faradayUrlLabel).addComponent(usernameLabel).addComponent(passwordLabel).addComponent(secondFactorLabel).addComponent(this.statusButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.faradayUrlText, 256, 256, 256).addComponent(this.usernameText, 256, 256, 256).addComponent(this.passwordField, 256, 256, 256).addComponent(this.secondFactorField, 256, 256, 256).addComponent(this.loginStatusLabel)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(faradayUrlLabel).addComponent(this.faradayUrlText)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(usernameLabel).addComponent(this.usernameText)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(passwordLabel).addComponent(this.passwordField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(secondFactorLabel).addComponent(this.secondFactorField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.statusButton).addComponent(this.loginStatusLabel)));
        layout.linkSize(1, faradayUrlLabel, usernameLabel, passwordLabel, secondFactorLabel);
        layout.linkSize(1, this.faradayUrlText, this.usernameText, this.passwordField, this.secondFactorField);
        layout.linkSize(0, this.faradayUrlText, this.usernameText, this.passwordField, this.secondFactorField);
        return loginPanel;
    }

    private Component setupSettingsPanel() {
        JPanel settingsPannel = new JPanel();
        settingsPannel.setBorder(BorderFactory.createTitledBorder("Extension Settings"));
        JCheckBox inScopeCheckbox = new JCheckBox("Only in Burp scope");
        JCheckBox importNewVulnsCheckbox = new JCheckBox("Import new vulnerabilities automatically");
        importNewVulnsCheckbox.addItemListener(itemEvent -> this.extensionSettings.setImportNewVulns(itemEvent.getStateChange() == 1));
        importNewVulnsCheckbox.setSelected(this.extensionSettings.importNewVulns());
        JButton importCurrentVulnsButton = new JButton("Import current vulnerabilities");
        importCurrentVulnsButton.addActionListener(actionEvent -> this.onImportCurrentVulns(inScopeCheckbox.isSelected()));
        JLabel workspaceLabel = new JLabel("Active workspace: ");
        this.workspaceCombo = new JComboBox();
        this.workspaceCombo.setEnabled(false);
        this.workspaceCombo.addActionListener(actionEvent -> this.onWorkspaceSelected((Workspace)this.workspaceCombo.getSelectedItem()));
        GroupLayout layout = new GroupLayout(settingsPannel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        settingsPannel.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(importNewVulnsCheckbox).addComponent(importCurrentVulnsButton).addComponent(workspaceLabel)).addGroup(layout.createParallelGroup().addComponent(inScopeCheckbox).addComponent(this.workspaceCombo)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(importNewVulnsCheckbox).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(importCurrentVulnsButton).addComponent(inScopeCheckbox)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(workspaceLabel).addComponent(this.workspaceCombo, -2, -1, -2)));
        return settingsPannel;
    }

    private Component setupOtherSettingsPanel() {
        JPanel otherSettingsPanel = new JPanel();
        otherSettingsPanel.setBorder(BorderFactory.createTitledBorder("Other Settings"));
        JButton restoreButton = new JButton("Restore Settings");
        restoreButton.addActionListener(actionEvent -> this.restoreSettings());
        GroupLayout layout = new GroupLayout(otherSettingsPanel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        otherSettingsPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(restoreButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(restoreButton));
        return otherSettingsPanel;
    }

    private void onStatusPressed() {
        switch (this.status) {
            case DISCONNECTED: {
                this.connect();
                break;
            }
            case CONNECTED: {
                this.login();
                break;
            }
            case NEEDS_2FA: {
                this.verifyToken();
                break;
            }
            case LOGGED_IN: {
                this.logout();
            }
        }
    }

    private void login() {
        String username = this.usernameText.getText().trim();
        if (username.isEmpty()) {
            this.showErrorAlert("Username is empty.");
            return;
        }
        String password = new String(this.passwordField.getPassword()).trim();
        if (password.isEmpty()) {
            this.showErrorAlert("Password is empty.");
            return;
        }
        try {
            this.faradayConnector.login(username, password);
        }
        catch (InvalidCredentialsException e) {
            this.showErrorAlert("Invalid credentials.");
            this.passwordField.setText("");
            this.setStatus("Invalid credentials");
            return;
        }
        catch (SecondFactorRequiredException e) {
            this.secondFactorField.setEnabled(true);
            this.setStatus("2FA Token required");
            this.statusButton.setText("Verify Token");
            this.usernameText.setEditable(false);
            this.passwordField.setEditable(false);
            this.extensionSettings.setUsername(username);
            this.secondFactorField.setEditable(true);
            JOptionPane.showMessageDialog(this.tab, "The 2FA token is required", "Error", 1);
            this.status = FaradayConnectorStatus.NEEDS_2FA;
            return;
        }
        catch (InvalidFaradayServerException e) {
            this.showErrorAlert("Invalid Faraday server URL.");
            return;
        }
        this.extensionSettings.setUsername(username);
        this.notifyLoggedIn(true);
    }

    private void verifyToken() {
        String token = this.secondFactorField.getText().trim();
        if (token.isEmpty()) {
            this.showErrorAlert("Token is empty.");
            return;
        }
        try {
            this.faradayConnector.verify2FAToken(token);
        }
        catch (InvalidCredentialsException e) {
            this.log("Error when validating token");
            this.showErrorAlert("Invalid token.");
            return;
        }
        catch (InvalidFaradayServerException e) {
            this.showErrorAlert("Unable to connect to Faraday.");
        }
        this.notifyLoggedIn(true);
        this.secondFactorField.setEditable(false);
    }

    private void connect() {
        String faradayUrl = this.faradayUrlText.getText().trim();
        if (faradayUrl.isEmpty()) {
            this.showErrorAlert("Faraday URL is empty.");
            return;
        }
        this.faradayConnector.setBaseUrl(faradayUrl);
        try {
            this.faradayConnector.validateFaradayURL();
        }
        catch (InvalidFaradayServerException e) {
            this.showErrorAlert("Faraday Server URL is not a valid Faraday server.");
            return;
        }
        catch (ServerTooOldException e) {
            this.showErrorAlert("Faraday server is too old to be used with this extension. Please upgrade to the latest version.");
            return;
        }
        this.usernameText.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.statusButton.setText("Login");
        this.faradayUrlText.setEditable(false);
        this.setStatus("Connected");
        this.status = FaradayConnectorStatus.CONNECTED;
    }

    private void logout() {
        this.faradayUrlText.setEditable(true);
        this.usernameText.setEditable(true);
        this.passwordField.setEditable(true);
        this.passwordField.setText("");
        this.extensionSettings.setPassword("");
        this.secondFactorField.setEnabled(false);
        this.secondFactorField.setText("");
        this.setStatus("Not connected");
        this.statusButton.setText("Connect");
        this.status = FaradayConnectorStatus.DISCONNECTED;
        this.faradayConnector.logout();
        FaradayConnector.clearCookies();
        this.workspaceCombo.removeAllItems();
        this.disablePanel(this.settingsPannel);
    }

    public void notifyLoggedIn(boolean showAlert) {
        if (showAlert) {
            JOptionPane.showMessageDialog(this.tab, "Login successful!", "Logged in", 1);
        }
        this.faradayUrlText.setEditable(false);
        this.usernameText.setEditable(false);
        this.passwordField.setEditable(false);
        this.statusButton.setText("Logout");
        this.setStatus("Logged in");
        this.status = FaradayConnectorStatus.LOGGED_IN;
        this.loadWorkspaces();
        this.enablePanel(this.settingsPannel);
        this.extensionSettings.setUsername(this.usernameText.getText());
        this.extensionSettings.setPassword(new String(this.passwordField.getPassword()).trim());
        this.extensionSettings.setFaradayURL(this.faradayUrlText.getText());
    }

    public void notify2FATokenNeeded() {
        this.usernameText.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.faradayUrlText.setEditable(false);
        this.usernameText.setEditable(false);
        this.passwordField.setEditable(false);
        this.secondFactorField.setEnabled(true);
        this.secondFactorField.setEditable(true);
        this.setStatus("2FA Token required");
        this.statusButton.setText("Verify Token");
        this.status = FaradayConnectorStatus.NEEDS_2FA;
    }

    private void restoreSettings() {
        this.logout();
        this.extensionSettings.restore();
        FaradayConnector.clearCookies();
        this.faradayUrlText.setText(this.extensionSettings.getDefaultFaradayUrl());
    }

    private void loadWorkspaces() {
        String currentWorkspaceName = this.extensionSettings.getCurrentWorkspace();
        this.workspaceCombo.removeAllItems();
        try {
            List<Workspace> workspaceList = this.faradayConnector.getWorkspaces();
            workspaceList.forEach(this.workspaceCombo::addItem);
            if (!currentWorkspaceName.isEmpty()) {
                workspaceList.stream().filter(workspace -> workspace.getName().equals(currentWorkspaceName)).findFirst().ifPresent(workspace -> this.workspaceCombo.setSelectedItem(workspace));
            }
        }
        catch (CookieExpiredException | InvalidFaradayServerException e) {
            this.log("Could not fetch workspaces: " + e);
        }
    }

    private void onWorkspaceSelected(Workspace workspace) {
        if (workspace == null) {
            return;
        }
        this.faradayConnector.setCurrentWorkspace(workspace);
        this.extensionSettings.setCurrentWorkspace(workspace.getName());
    }

    private void onImportCurrentVulns(boolean onlyInScope) {
        FaradayExtensionUI.runInThread(() -> {
            Vulnerability vulnerability;
            List<IScanIssue> issues = Arrays.asList(this.callbacks.getScanIssues(null));
            if (onlyInScope) {
                issues = issues.stream().filter(issue -> this.callbacks.isInScope(issue.getUrl())).collect(Collectors.toList());
            }
            List vulnerabilities = issues.stream().map(VulnerabilityMapper::fromIssue).collect(Collectors.toList());
            Workspace workspace = this.faradayConnector.getCurrentWorkspace();
            Iterator iterator = vulnerabilities.iterator();
            while (iterator.hasNext() && this.addVulnerability(vulnerability = (Vulnerability)iterator.next(), workspace)) {
            }
        });
    }

    @Override
    public String getTabCaption() {
        return "Faraday";
    }

    @Override
    public Component getUiComponent() {
        return this.tab;
    }

    private void setStatus(String status) {
        this.loginStatusLabel.setText(status);
    }

    private void log(String msg) {
        this.stdout.println("[UI] " + msg);
    }

    private void disablePanel(Component panel) {
        Arrays.stream(((Container)panel).getComponents()).forEach(component -> component.setEnabled(false));
        panel.setEnabled(false);
    }

    private void enablePanel(Component panel) {
        Arrays.stream(((Container)panel).getComponents()).forEach(component -> component.setEnabled(true));
        panel.setEnabled(true);
    }

    public void showErrorAlert(String message) {
        this.showAlert(message, 0);
    }

    public void showInfoAlert(String message) {
        this.showAlert(message, 1);
    }

    private void showAlert(String message, int type) {
        this.log(message);
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.tab, message, "Info", type));
    }

    public boolean addVulnerability(Vulnerability vulnerability, Workspace workspace) {
        try {
            this.faradayConnector.addVulnerabilityToWorkspace(vulnerability, workspace);
        }
        catch (ObjectNotCreatedException e) {
            this.log("Unable to create object tree");
            this.showErrorAlert("There was an error creating the objects.");
            return false;
        }
        catch (InvalidFaradayServerException e) {
            this.showErrorAlert("Could not connect to Faraday Server. Please check that it is running and that you are authenticated.");
            return false;
        }
        return true;
    }

    public static void runInThread(final Runnable runnable) {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                runnable.run();
                return null;
            }
        }.execute();
    }
}

