Version 0.13 has been released on 2020-01-01, 18 months after 0.12, bringing
many new features and bugfixes.

As usual, [prebuilt binaries](https://elv.sh/get) are offered for most common
platforms.

# Breaking changes

-   This release sees a total rewrite of the line editor. As a result, there
    have been some changes to its API, the `edit:` module:

    -   Binding tables no longer support the `default` key for overriding the
        default behavior of modes. All the `edit:<mode>:default` functions have
        been removed: `edit:completion:default`, `edit:history:default`,
        `edit:insert:default`, `edit:listing:default` and
        `edit:navigation:default`.

        The `edit:insert-key` and `edit:listing:backspace` functions have also
        been removed. Their functionalities are now baked into the default
        behavior of the insert and listing modes.

    -   The `edit:history:list` function has been removed. Use
        `edit:command history` instead.

    -   The `edit:lastcmd:accept-line` function has been removed. Use
        `edit:listing:accept` instead.

    -   The `edit:-narrow-read` function and the `edit:narrow:` module have been
        removed. Used `edit:listing:start-custom` instead.

    -   The `edit:styled` function has been removed. Used `styled` instead.

    -   The `edit:insert:start` function has been removed. Use
        `edit:close-listing` instead.

    -   The `edit:location:matcher` variable and
        `edit:location:match-dir-pattern` function have been removed. There is
        no replacement yet; the location matcher is not customizable now,
        although it may be made customizable again in a future version.

    -   The `edit:completion:trigger-filter` function has been removed. The
        completion mode now always focuses on the filter, and it is no longer
        possible to focus on the main buffer during completion.

    -   The `edit:history:list` function has been removed. There is no
        replacement yet.

-   The names of basic colors used in `styled` has changed to be more standard:

    -   The `lightgray` color (ANSI code 37) is now called `white`.

    -   The `gray` color (ANSI code 90) is now called `bright-black`.

    -   The `white` color (ANSI code 97) is now called `bright-white`.

    -   All the `lightX` (ANSI codes 90 to 97) colors have been renamed to
        `bright-X`.

-   Builtin math functions now output values of an explicit `float64` number
    type instead of strings.

# Notable fixes and enhancements

-   The editor now has a minibuffer, bound to <kbd>Alt-x</kbd> by default. The
    minibuffer allows you to execute editor commands without binding them to a
    key.

-   The editor now has an experimental "instant mode" that can be activated with
    `edit:-instant:start`. It is not bound by default. The instant mode executes
    the code on the command line every time it changes.

    **WARNING**: Beware of unintended consequences when using destructive
    commands. For example, if you type `sudo rm -rf /tmp/*` in instant mode,
    Elvish will attempt to execute `sudo rm -rf /` when you typed so far.

-   The `styled` builtin now supports more color spaces:

    -   Colors from the xterm 256-color palette can be specified as `colorN`,
        such as `color22`.

    -   24-bit RGB colors can be specified as `#RRGGBB`, such as `#00ffa0`.

    Proper terminal support is required to display those colors.

-   Elvish can now output results in JSON in compile-only mode, by specifying
    `-compileonly -json`, thanks to @jiujieti ([PR #858](https://pr.elv.sh/858))
    and @sblundy ([PR #874](https://pr.elv.sh/874)).

-   In redirections, the 3 standard file descriptors may be specified as names
    (`stdin`, `stdout`, `stderr` ) instead of numbers, thanks to @jiujieti
    ([PR #869](https://pr.elv.sh/869)).

-   Code such as `x = $x` where `$x` has not been defined now correctly results
    in a compilation error, thanks to @jiujieti
    ([PR #872](https://pr.elv.sh/872)).

-   The `while` special form now supports an `else` clause, thanks to @0x005c
    ([PR #863](https://pr.elv.sh/863)). This feature was previously documented
    but missing implementation.

-   The command `%` no longer crashes Elvish when the divisor is 0, thanks to
    @0x005c ([PR #866](https://pr.elv.sh/866)).

-   Elvish is now resilient against terminal programs that leave the terminal in
    non-blocking IO state ([issue #588](https://b.elv.sh/588) and
    [issue #822](https://b.elv.sh/822)).

-   Wildcard patterns of multiple question marks (like `a??`) are now parsed
    correctly ([issue #848](https://b.elv.sh/848)).

-   A new floating-point numeric type has been introduced, and can be
    constructed with the `float64` builtin function
    ([issue #816](https://b.elv.sh/816)).

-   A new `$nil` value has been introduced to represent lack of meaningful
    values. JSON `null` values are converted to Elvish `$nil`.

-   Two new builtins, `only-bytes` and `only-values` have been introduced. They
    can read a mixture of byte and value inputs and only keep one type and
    discard the other type.

-   The `use` special form now accepts an optional second argument for renaming
    the imported module.

-   A new `chr` builtin that converts a number to its corresponding Unicode
    character has been added.

-   New editor builtin commands `edit:kill-word-right` and
    `edit:kill-word-right` has been added, thanks to @kwshi
    ([PR #721](https://pr.elv.sh/721)).
