/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.report;

import com.sittinglittleduck.DirBuster.Manager;
import com.sittinglittleduck.DirBuster.Result;
import com.sittinglittleduck.DirBuster.gui.StartGUI;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportWriter {
    private String fileToWriteTo;
    private StartGUI gui;
    private Manager manager;
    private Vector<Result> data;

    public ReportWriter(String fileToWriteTo, StartGUI gui) {
        this.fileToWriteTo = fileToWriteTo;
        this.gui = gui;
        this.manager = Manager.getInstance();
        this.data = this.manager.results;
    }

    public ReportWriter(String fileToWriteTo) {
        this.fileToWriteTo = fileToWriteTo;
        this.manager = Manager.getInstance();
        this.data = this.manager.results;
    }

    public void writeReport() {
        Integer code;
        int b;
        Vector<Result> data = this.manager.results;
        Vector<Result> dirs = new Vector<Result>(100, 10);
        Vector<Result> files = new Vector<Result>(100, 10);
        Vector errors = new Vector(100, 10);
        Vector<Integer> dirCodes = new Vector<Integer>(100, 10);
        Vector<Integer> fileCodes = new Vector<Integer>(100, 10);
        for (int a = 0; a < data.size(); ++a) {
            if (data.elementAt(a).getType() == 1) {
                files.addElement(data.elementAt(a));
                continue;
            }
            if (data.elementAt(a).getType() != 0) continue;
            dirs.addElement(data.elementAt(a));
        }
        for (b = 0; b < dirs.size(); ++b) {
            code = new Integer(((Result)dirs.elementAt(b)).getResponceCode());
            if (dirCodes.contains(code)) continue;
            dirCodes.addElement(code);
        }
        for (b = 0; b < files.size(); ++b) {
            code = new Integer(((Result)files.elementAt(b)).getResponceCode());
            if (fileCodes.contains(code)) continue;
            fileCodes.addElement(code);
        }
        try {
            int b2;
            int code2;
            BufferedWriter out = new BufferedWriter(new FileWriter(this.fileToWriteTo + ".txt"));
            this.writeReportHeader(out);
            if (dirs.size() > 0) {
                out.write("Directories found during testing:");
                out.newLine();
                out.newLine();
                for (int a = 0; a < dirCodes.size(); ++a) {
                    code2 = (Integer)dirCodes.elementAt(a);
                    out.write("Dirs found with a " + code2 + " response:");
                    out.newLine();
                    out.newLine();
                    for (b2 = 0; b2 < dirs.size(); ++b2) {
                        if (code2 != ((Result)dirs.elementAt(b2)).getResponceCode()) continue;
                        out.write(((Result)dirs.elementAt(b2)).getItemFound().getPath());
                        out.newLine();
                    }
                    out.newLine();
                }
                out.newLine();
                out.write("--------------------------------");
                out.newLine();
            }
            if (files.size() > 0) {
                out.write("Files found during testing:");
                out.newLine();
                out.newLine();
                for (int a = 0; a < fileCodes.size(); ++a) {
                    code2 = (Integer)fileCodes.elementAt(a);
                    out.write("Files found with a " + code2 + " responce:");
                    out.newLine();
                    out.newLine();
                    for (b2 = 0; b2 < files.size(); ++b2) {
                        if (code2 != ((Result)files.elementAt(b2)).getResponceCode()) continue;
                        out.write(((Result)files.elementAt(b2)).getItemFound().getPath());
                        out.newLine();
                    }
                    out.newLine();
                }
                out.newLine();
            }
            out.write("--------------------------------");
            out.newLine();
            if (errors.size() > 0) {
                out.write("Errors encountered during testing:");
                out.newLine();
                out.newLine();
                for (int a = 0; a < this.manager.errors.size(); ++a) {
                    out.write(this.manager.errors.elementAt(a).getUrl().toString() + " : " + this.manager.errors.elementAt(a).getReason());
                    out.newLine();
                }
                out.newLine();
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void writeReportHeader(BufferedWriter out) throws IOException {
        out.write("DirBuster 1.0-RC1 - Report");
        out.newLine();
        out.write("http://www.owasp.org/index.php/Category:OWASP_DirBuster_Project");
        out.newLine();
        Date date = new Date(System.currentTimeMillis());
        out.write("Report produced on " + date);
        out.newLine();
        out.write("--------------------------------");
        out.newLine();
        out.newLine();
        out.write(this.manager.getProtocol() + "://" + this.manager.getHost() + ":" + this.manager.getPort());
        out.newLine();
        out.write("--------------------------------");
        out.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSimpleListDirsOnly() {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(this.fileToWriteTo + "-simple.txt"));
            this.writeSimpleListDirs(out);
        }
        catch (IOException ex) {
            Logger.getLogger(ReportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ReportWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSimpleListFilesOnly() {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(this.fileToWriteTo + "-simple.txt"));
            this.writeSimpleListFiles(out);
        }
        catch (IOException ex) {
            Logger.getLogger(ReportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ReportWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSimpleListFilesAndDirs() {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(this.fileToWriteTo + "-simple.txt"));
            this.writeSimpleListDirs(out);
            this.writeSimpleListFiles(out);
        }
        catch (IOException ex) {
            Logger.getLogger(ReportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ReportWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXML() {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(this.fileToWriteTo + ".xml"));
            out.write("<?xml version=\"1.0>");
            out.newLine();
            out.write("<DirBusterResults>");
            out.newLine();
            for (int a = 0; a < this.data.size(); ++a) {
                String type = "";
                if (this.data.elementAt(a).getType() == 0) {
                    type = "Dir";
                } else if (this.data.elementAt(a).getType() == 1) {
                    type = "File";
                }
                out.write("<Result type=\"" + type + "\" path=\"" + this.data.elementAt(a).getItemFound().getPath() + "\" responseCode=\"" + this.data.elementAt(a).getResponceCode() + "\" />");
                out.newLine();
            }
            out.write("</DirBusterResults>");
            out.newLine();
        }
        catch (IOException ex) {
            Logger.getLogger(ReportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ReportWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCSV() {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(this.fileToWriteTo + ".csv"));
            out.write("\"Found\",\"Response Code\",\"Content Length\"");
            out.newLine();
            for (int a = 0; a < this.data.size(); ++a) {
                out.write("\"" + this.data.elementAt(a).getItemFound().getPath() + "\",\"" + this.data.elementAt(a).getResponceCode() + "\",\"" + (this.data.elementAt(a).getResponseHeader() + this.data.elementAt(a).getResponseBody()).length() + "\"");
                out.newLine();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ReportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ReportWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void writeSimpleListDirs(BufferedWriter out) throws IOException {
        for (int a = 0; a < this.data.size(); ++a) {
            if (this.data.elementAt(a).getType() != 0) continue;
            out.write(this.data.elementAt(a).getItemFound().getPath());
            out.newLine();
        }
    }

    private void writeSimpleListFiles(BufferedWriter out) throws IOException {
        for (int a = 0; a < this.data.size(); ++a) {
            if (this.data.elementAt(a).getType() != 1) continue;
            out.write(this.data.elementAt(a).getItemFound().getPath());
            out.newLine();
        }
    }
}

