/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.text.IUndoManager;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.editors.entity.handlers.ObjectPropertySwitchToSourceHandler;

public class EntityEditorPropertyTester
extends PropertyTester {
    private static final Log log = Log.getLog(EntityEditorPropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.ui.editors.entity";
    public static final String PROP_DIRTY = "dirty";
    public static final String PROP_CAN_UNDO = "canUndo";
    public static final String PROP_CAN_REDO = "canRedo";
    public static final String PROP_HAS_SOURCE = "hasSource";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        block25: {
            EntityEditor editor;
            block23: {
                if (!(receiver instanceof EntityEditor)) {
                    return false;
                }
                editor = (EntityEditor)receiver;
                if (PROP_DIRTY.equals(property)) {
                    return editor.isDirty();
                }
                if (PROP_HAS_SOURCE.equals(property)) {
                    return ObjectPropertySwitchToSourceHandler.findSourceTextEditorId(editor) != null;
                }
                IUndoManager undoManager = editor.getAdapter(IUndoManager.class);
                if (undoManager == null) break block23;
                switch (property) {
                    case "canUndo": {
                        return undoManager.undoable();
                    }
                    case "canRedo": {
                        return undoManager.redoable();
                    }
                }
                break block25;
            }
            DBECommandContext commandContext = editor.getEditorInput().getCommandContext();
            if (commandContext == null) break block25;
            switch (property) {
                case "canUndo": {
                    return commandContext.getUndoCommand() != null;
                }
                case "canRedo": {
                    return commandContext.getRedoCommand() != null;
                }
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.ui.editors.entity." + propName));
    }
}

