/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WorkbenchPatcher {
    private static final Log log = Log.getLog(WorkbenchPatcher.class);

    private WorkbenchPatcher() {
    }

    public static void patchWorkbenchXmi(@NotNull Location instance) {
        Path path = WorkbenchPatcher.getWorkbenchSaveLocation(instance);
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            WorkbenchPatcher.patchWorkbenchXmi(path);
        }
        catch (Throwable e) {
            log.error((Object)("Failed to patch workbench state file: " + String.valueOf(path)), e);
        }
    }

    private static void patchWorkbenchXmi(@NotNull Path workbenchXmi) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(workbenchXmi.toFile());
        Map<String, PartDescriptor> parts = WorkbenchPatcher.collectContributedParts();
        boolean transformed = WorkbenchPatcher.patchPartIconsRecursively(document, parts);
        if (transformed) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "no");
            Throwable throwable = null;
            Object var9_10 = null;
            try (OutputStream os = Files.newOutputStream(workbenchXmi, new OpenOption[0]);){
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static boolean patchPartIconsRecursively(@NotNull Node node, @NotNull Map<String, PartDescriptor> parts) {
        NodeList children = node.getChildNodes();
        boolean modified = false;
        int i = 0;
        while (i < children.getLength()) {
            Node node2 = children.item(i);
            if (node2 instanceof Element) {
                Element child = (Element)node2;
                if (child.hasAttribute("elementId") && child.hasAttribute("iconURI")) {
                    PartDescriptor part;
                    Attr iconURI = child.getAttributeNode("iconURI");
                    String elementId = child.getAttribute("elementId");
                    if (elementId.equals("org.eclipse.e4.ui.compatibility.editor")) {
                        elementId = WorkbenchPatcher.extractCompatibilityEditorId(child);
                    }
                    if ((part = parts.get(elementId)) != null && !iconURI.getNodeValue().equals(part.icon())) {
                        log.debug((Object)("Replacing icon for part '" + part.id() + "' with '" + part.icon() + "'"));
                        iconURI.setNodeValue(part.icon());
                        modified = true;
                    }
                }
                modified |= WorkbenchPatcher.patchPartIconsRecursively(child, parts);
            }
            ++i;
        }
        return modified;
    }

    @Nullable
    private static String extractCompatibilityEditorId(@NotNull Element element) {
        Element persistedState = XMLUtils.getChildElement((Element)element, (String)"persistedState");
        if (persistedState == null) {
            return null;
        }
        String key = persistedState.getAttribute("key");
        String value = persistedState.getAttribute("value");
        if (!"memento".equals(key)) {
            return null;
        }
        try {
            Document memento = XMLUtils.parseDocument((Reader)new StringReader(value));
            Element editor = memento.getDocumentElement();
            if (editor.getTagName().equals("editor") && editor.hasAttribute("id")) {
                return editor.getAttribute("id");
            }
        }
        catch (XMLException e) {
            log.debug((Object)"Error parsing editor memento", (Throwable)e);
        }
        return null;
    }

    @NotNull
    private static Map<String, PartDescriptor> collectContributedParts() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        List<PartDescriptor> views = Stream.of(registry.getExtensionPoint("org.eclipse.ui.views").getExtensions()).map(IExtension::getConfigurationElements).flatMap(iConfigurationElementArray -> Stream.of(iConfigurationElementArray)).filter(e -> e.getName().equals("view") && e.getAttribute("icon") != null).map(PartDescriptor::of).toList();
        List<PartDescriptor> editors = Stream.of(registry.getExtensionPoint("org.eclipse.ui.editors").getExtensions()).map(IExtension::getConfigurationElements).flatMap(iConfigurationElementArray -> Stream.of(iConfigurationElementArray)).filter(e -> e.getName().equals("editor") && e.getAttribute("icon") != null).map(PartDescriptor::of).toList();
        return Stream.concat(views.stream(), editors.stream()).collect(Collectors.toMap(PartDescriptor::id, Function.identity(), (a, b) -> b));
    }

    @Nullable
    private static Path getWorkbenchSaveLocation(@NotNull Location instance) {
        try {
            Path path = RuntimeUtils.getLocalPathFromURL((URL)instance.getURL());
            return path.resolve(".metadata/.plugins/org.eclipse.e4.workbench/workbench.xmi");
        }
        catch (IOException e) {
            log.error((Object)("Unable to resolve workbench save location: " + String.valueOf(instance.getURL())), (Throwable)e);
            return null;
        }
    }

    private record PartDescriptor(@NotNull IConfigurationElement element, @NotNull String id, @NotNull String icon) {
        @NotNull
        static PartDescriptor of(@NotNull IConfigurationElement element) {
            String id = element.getAttribute("id");
            String icon = MenuHelper.getIconURI((IConfigurationElement)element, (String)"icon");
            return new PartDescriptor(element, id, icon);
        }
    }
}

