/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.copilot;

import com.google.gson.annotations.SerializedName;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotModels;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.utils.CommonUtils;

public class CopilotProperties
implements AIEngineProperties {
    @SecureProperty
    @SerializedName(value="copilot.access.token")
    @Nullable
    private String token;
    @SerializedName(value="gpt.model")
    @Nullable
    private String model;
    @SerializedName(value="gpt.contextWindowSize")
    @Nullable
    private Integer contextWindowSize;
    @SerializedName(value="gpt.model.temperature")
    private double temperature;
    @SerializedName(value="gpt.log.query")
    private boolean loggingEnabled;

    @Nullable
    public String getToken() {
        return this.token;
    }

    public void setToken(@Nullable String token) {
        this.token = token;
    }

    @Nullable
    public String getModel() {
        return this.model;
    }

    public void setModel(@Nullable String model) {
        this.model = model;
    }

    @Nullable
    public Integer getContextWindowSize() {
        if (this.contextWindowSize != null) {
            return this.contextWindowSize;
        }
        if (this.model == null || this.model.isBlank()) {
            return null;
        }
        return CopilotModels.getContextWindowSize(this.model);
    }

    public void setContextWindowSize(@Nullable Integer contextWindowSize) {
        this.contextWindowSize = contextWindowSize;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    @Override
    public void resolveSecrets() throws DBException {
        this.token = AIUtils.getSecretValueOrDefault("copilot.access.token", this.token);
    }

    @Override
    public void saveSecrets() throws DBException {
        if (this.token != null) {
            DBSSecretController.getGlobalSecretController().setPrivateSecretValue("copilot.access.token", this.token);
        }
    }

    @Override
    public boolean isValidConfiguration() {
        return !CommonUtils.isEmpty((String)this.getToken());
    }
}

