/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.views;

import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleLanguage;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleTerritory;
import org.jkiss.dbeaver.ext.oracle.ui.internal.OracleUIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class OracleConnectionExtraPage
extends ConnectionPageAbstract {
    private Combo languageCombo;
    private Combo territoryCombo;
    private Text nlsDateFormat;
    private Text nlsTimestampFormat;
    private Text nlsLengthFormat;
    private Text nlsCurrencyFormat;
    private Button showOnlyOneSchema;
    private Button hideEmptySchemasCheckbox;
    private Button showDBAAlwaysCheckbox;
    private Button useDBAViewsCheckbox;
    private Button useSysSchemaCheckbox;
    private Button useRuleHint;
    private Button useOptimizerHint;
    private Button useSimpleConstraints;
    private Button useAlternativeTableMetadataQuery;
    private Button searchInSynonyms;
    private Button searchInSequences;
    private Button showDateAsDate;

    public OracleConnectionExtraPage() {
        this.setTitle(OracleUIMessages.dialog_connection_oracle_properties);
        this.setDescription(OracleUIMessages.dialog_connection_oracle_properties_description);
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite cfgGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        cfgGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        cfgGroup.setLayoutData((Object)gd);
        Group sessionGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)OracleUIMessages.dialog_controlgroup_session_settings, (int)2, (int)32, (int)0);
        ((GridData)sessionGroup.getLayoutData()).horizontalSpan = 2;
        this.languageCombo = UIUtils.createLabelCombo((Composite)sessionGroup, (String)OracleUIMessages.edit_label_combo_language, (int)4);
        this.languageCombo.setToolTipText(OracleUIMessages.edit_label_combo_language_tool_tip_text);
        this.languageCombo.add("Default");
        OracleLanguage[] oracleLanguageArray = OracleLanguage.values();
        int n = oracleLanguageArray.length;
        int n2 = 0;
        while (n2 < n) {
            OracleLanguage language = oracleLanguageArray[n2];
            this.languageCombo.add(language.getLanguage());
            ++n2;
        }
        this.languageCombo.setText("Default");
        this.territoryCombo = UIUtils.createLabelCombo((Composite)sessionGroup, (String)OracleUIMessages.edit_label_combo_territory, (int)4);
        this.territoryCombo.setToolTipText(OracleUIMessages.edit_label_combo_territory_tool_tip_text);
        this.territoryCombo.add("Default");
        oracleLanguageArray = OracleTerritory.values();
        n = oracleLanguageArray.length;
        n2 = 0;
        while (n2 < n) {
            OracleLanguage territory = oracleLanguageArray[n2];
            this.territoryCombo.add(territory.getTerritory());
            ++n2;
        }
        this.territoryCombo.setText("Default");
        this.nlsDateFormat = UIUtils.createLabelText((Composite)sessionGroup, (String)OracleUIMessages.edit_label_text_date_format, (String)"");
        this.nlsTimestampFormat = UIUtils.createLabelText((Composite)sessionGroup, (String)OracleUIMessages.edit_label_text_timestamp_format, (String)"");
        this.nlsLengthFormat = UIUtils.createLabelText((Composite)sessionGroup, (String)OracleUIMessages.edit_label_text_length_format, (String)"");
        this.nlsCurrencyFormat = UIUtils.createLabelText((Composite)sessionGroup, (String)OracleUIMessages.edit_label_text_currency_format, (String)"");
        Group performanceGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)OracleUIMessages.dialog_controlgroup_performance, (int)1, (int)32, (int)0);
        this.useOptimizerHint = UIUtils.createCheckbox((Composite)performanceGroup, (String)OracleUIMessages.edit_create_checkbox_group_use_metadata_optimizer, (boolean)true);
        this.useOptimizerHint.setToolTipText(OracleUIMessages.edit_create_checkbox_group_use_metadata_optimizer_tip);
        this.useRuleHint = UIUtils.createCheckbox((Composite)performanceGroup, (String)OracleUIMessages.edit_create_checkbox_group_use_rule, (boolean)true);
        this.useRuleHint.setToolTipText(OracleUIMessages.edit_create_checkbox_adds_rule_tool_tip_text);
        this.useSimpleConstraints = UIUtils.createCheckbox((Composite)performanceGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_use_simple_constraints, (String)OracleUIMessages.edit_create_checkbox_content_group_use_simple_constraints_description, (boolean)false, (int)1);
        this.useAlternativeTableMetadataQuery = UIUtils.createCheckbox((Composite)performanceGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_use_another_table_query, (boolean)false);
        this.useAlternativeTableMetadataQuery.setToolTipText(OracleUIMessages.edit_create_checkbox_content_group_use_another_table_query_description);
        this.searchInSynonyms = UIUtils.createCheckbox((Composite)performanceGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_search_metadata_in_synonyms, (boolean)false);
        this.searchInSynonyms.setToolTipText(OracleUIMessages.edit_create_checkbox_content_group_search_metadata_in_synonyms_tooltip);
        this.searchInSequences = UIUtils.createCheckbox((Composite)performanceGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_search_metadata_in_sequences, (boolean)false);
        this.searchInSequences.setToolTipText(OracleUIMessages.edit_create_checkbox_content_group_search_metadata_in_sequences_tooltip);
        Group contentGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)OracleUIMessages.dialog_controlgroup_content, (int)1, (int)34, (int)0);
        this.showOnlyOneSchema = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.connection_extra_page_checkbox_show_only_one_schema, (String)OracleUIMessages.connection_extra_page_checkbox_show_only_one_schema_tip, (boolean)false, (int)1);
        this.hideEmptySchemasCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_hide_empty_schemas, (boolean)false);
        this.hideEmptySchemasCheckbox.setToolTipText(OracleUIMessages.edit_create_checkbox_hide_empty_schemas_tool_tip_text);
        this.showDBAAlwaysCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_show, (String)OracleUIMessages.edit_create_checkbox_content_group_show_description, (boolean)false, (int)1);
        this.useDBAViewsCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_use, (String)OracleUIMessages.edit_create_checkbox_content_group_use_description, (boolean)false, (int)1);
        this.useSysSchemaCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)OracleUIMessages.edit_create_checkbox_content_group_use_sys_schema, (String)OracleUIMessages.edit_create_checkbox_content_group_use_sys_schema_description, (boolean)false, (int)1);
        Group dataGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)OracleUIMessages.pref_page_oracle_group_data, (int)1, (int)32, (int)0);
        this.showDateAsDate = UIUtils.createCheckbox((Composite)dataGroup, (String)OracleUIMessages.pref_page_oracle_checkbox_show_date_as_date, (String)OracleUIMessages.pref_page_oracle_checkbox_show_date_as_date_tip, (boolean)false, (int)1);
        this.setControl((Control)cfgGroup);
        this.loadSettings();
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        Object nlsTerritory;
        DBPPreferenceStore globalPreferences = DBWorkbench.getPlatform().getPreferenceStore();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        Map providerProperties = connectionInfo.getProviderProperties();
        Object nlsLanguage = providerProperties.get("@dbeaver-session-language@");
        if (nlsLanguage != null) {
            this.languageCombo.setText(nlsLanguage.toString());
        }
        if ((nlsTerritory = providerProperties.get("@dbeaver-session-territory@")) != null) {
            this.territoryCombo.setText(nlsTerritory.toString());
        }
        this.nlsDateFormat.setText(CommonUtils.toString(providerProperties.get("@dbeaver-session-nls-date-format@")));
        this.nlsTimestampFormat.setText(CommonUtils.toString(providerProperties.get("session-nls-timestamp-format")));
        this.nlsLengthFormat.setText(CommonUtils.toString(providerProperties.get("session-nls-length-format")));
        this.nlsCurrencyFormat.setText(CommonUtils.toString(providerProperties.get("session-nls-currency-format")));
        this.showOnlyOneSchema.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("show-only-one-schema@"))));
        Object checkSchemaContent = providerProperties.get("@dbeaver-check-schema-content@");
        if (checkSchemaContent != null) {
            this.hideEmptySchemasCheckbox.setSelection(CommonUtils.getBoolean(checkSchemaContent, (boolean)false));
        }
        this.showDBAAlwaysCheckbox.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-always-show-dba@")), (boolean)false));
        this.useDBAViewsCheckbox.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-always-use-dba-views@")), (boolean)false));
        this.useSysSchemaCheckbox.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-meta-use-sys-schema@")), (boolean)false));
        this.useSimpleConstraints.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-meta-use-simple-constraints@")), (boolean)globalPreferences.getBoolean("@dbeaver-meta-use-simple-constraints@")));
        this.useRuleHint.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-use-rule-hint@")), (boolean)globalPreferences.getBoolean("@dbeaver-use-rule-hint@")));
        this.useOptimizerHint.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-use-meta-optimizer@")), (boolean)globalPreferences.getBoolean("@dbeaver-use-meta-optimizer@")));
        this.useAlternativeTableMetadataQuery.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-meta-use-alternative-table-query@")), (boolean)globalPreferences.getBoolean("@dbeaver-meta-use-alternative-table-query@")));
        this.searchInSynonyms.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("oracle.meta-search-in-synonyms")), (boolean)globalPreferences.getBoolean("oracle.meta-search-in-synonyms")));
        this.searchInSequences.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("oracle.meta-search-in-sequences")), (boolean)globalPreferences.getBoolean("oracle.meta-search-in-sequences")));
        this.showDateAsDate.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("oracle.show-date-as-date")), (boolean)globalPreferences.getBoolean("oracle.show-date-as-date")));
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        Map providerProperties = dataSource.getConnectionConfiguration().getProviderProperties();
        if (!"Default".equals(this.languageCombo.getText())) {
            providerProperties.put("@dbeaver-session-language@", this.languageCombo.getText());
        } else {
            providerProperties.remove("@dbeaver-session-language@");
        }
        if (!"Default".equals(this.territoryCombo.getText())) {
            providerProperties.put("@dbeaver-session-territory@", this.territoryCombo.getText());
        } else {
            providerProperties.remove("@dbeaver-session-territory@");
        }
        OracleConnectionExtraPage.setOrRemoveProperty(this.nlsDateFormat, "@dbeaver-session-nls-date-format@", providerProperties);
        OracleConnectionExtraPage.setOrRemoveProperty(this.nlsTimestampFormat, "session-nls-timestamp-format", providerProperties);
        OracleConnectionExtraPage.setOrRemoveProperty(this.nlsLengthFormat, "session-nls-length-format", providerProperties);
        OracleConnectionExtraPage.setOrRemoveProperty(this.nlsCurrencyFormat, "session-nls-currency-format", providerProperties);
        providerProperties.put("show-only-one-schema@", String.valueOf(this.showOnlyOneSchema.getSelection()));
        providerProperties.put("@dbeaver-check-schema-content@", String.valueOf(this.hideEmptySchemasCheckbox.getSelection()));
        providerProperties.put("@dbeaver-always-show-dba@", String.valueOf(this.showDBAAlwaysCheckbox.getSelection()));
        providerProperties.put("@dbeaver-always-use-dba-views@", String.valueOf(this.useDBAViewsCheckbox.getSelection()));
        providerProperties.put("@dbeaver-meta-use-sys-schema@", String.valueOf(this.useSysSchemaCheckbox.getSelection()));
        providerProperties.put("@dbeaver-meta-use-simple-constraints@", String.valueOf(this.useSimpleConstraints.getSelection()));
        providerProperties.put("@dbeaver-use-rule-hint@", String.valueOf(this.useRuleHint.getSelection()));
        providerProperties.put("@dbeaver-use-meta-optimizer@", String.valueOf(this.useOptimizerHint.getSelection()));
        providerProperties.put("@dbeaver-meta-use-alternative-table-query@", String.valueOf(this.useAlternativeTableMetadataQuery.getSelection()));
        providerProperties.put("oracle.meta-search-in-synonyms", String.valueOf(this.searchInSynonyms.getSelection()));
        providerProperties.put("oracle.meta-search-in-sequences", String.valueOf(this.searchInSequences.getSelection()));
        providerProperties.put("oracle.show-date-as-date", String.valueOf(this.showDateAsDate.getSelection()));
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
    }

    private static void setOrRemoveProperty(Text text, String propName, Map<String, String> providerProperties) {
        String propValue = text.getText().trim();
        if (!propValue.isEmpty()) {
            providerProperties.put(propName, propValue);
        } else {
            providerProperties.remove(propName);
        }
    }
}

