#ifndef _PROGRAMMER_BASE_H_
#define _PROGRAMMER_BASE_H_

#include <string>
#include <vector>


class ProgrammerBase {
    protected:
        ProgrammerBase() {}
    public:
        typedef void progress_fn(unsigned int progress, unsigned int progressFull, const std::string & info, bool replace);
        virtual ~ProgrammerBase() {}
        virtual void connect(const std::string & port) = 0;
        virtual void configure(const std::string & part) = 0;
        virtual std::string getStatus() = 0;
        virtual void reset() {}
        virtual void erase() {}
        virtual void program(const std::string & segment, unsigned int startAddress, const std::vector<uint8_t> & memory) = 0;
        virtual void verify(const std::string & segment, unsigned int startAddress, const std::vector<uint8_t> & memory) = 0;
        virtual void startProgramMode(const std::string & mode, bool erase) = 0;
        virtual void leaveProgramMode() = 0;
        virtual void signalError() {}
        virtual void checkSignature() {}
};

#endif  // _PROGRAMMER_BASE_H_
