# FilterNet simulations from arbitary movies

One optional type of visual stimuli into the FilterNet simulation can be a movie generated by the modeler. The input file should be a .npy or .npz file made from a matrix of size `(frames, rows, columns)`. It should be grey-scaled single channel (LGN Model was not optimized for color movies). And the movies arrays can either be a floating-point type-matrix with contrast values normalized between [-1.0, +1.0], or an integer (uint8) with values between [0, 255]. 


In this network example we will show multiple ways of creating and playing custom movie files. Two examples are movies generated from the Allen Brain Observatory experiments and one just a grey-screen movie.


## Generating movie files

Because the movie .npy files can get pretty big, you must first generate these files using the `create_movie.py` script.

### Natural Scenes

As part of the Brain Observatory experiments mice we shown a sequence of 118 different static images in a randomized order. To recreate this experiment for FilterNet we will uses the following command to generate a movie from 20 of the different images.

```bash
 $ python create_movie.py --n-images=20 --images-per-sec=10 --greyscreen-pre=500.0 natural-scenes
```

with the following options
* **--n-images=20** - Uses only 20 of the 118 images in the Brain Observatory data set.
* **--images-per-sec=10** - Show 10 images every second (eg. the screen changes every 100 ms).
* **--greyscreen-pre=500.0** - Adds a grey-screen fro 500 ms at the beginning of the movie.

The .npy file will be saved to the *movies/* folder. To run FilterNet to generate retinal-thalamic spike trains generated from this movie you can use the `config.simulation_naturalscenes.json` config file:

```bash
 $ python run_filternet.py config.simulation_naturalscenes.json
```

Resulting spike-trains and rates file will be saved to the *output_naturalscenes/* folder as specified in the config.

### Natural Movies (eg. Touch of Evil)

For more naturalistic style movies, the Brain Observatory experiments included showing clips from the Orson Wells films "Touch of Evil", with two clips at 30 seconds and one clip at 120 seconds. To use this input with FilterNet we need to not only convert the movie files to .npy. But we must also resize to fit our model's field-size (120x240) as-well-as upscale the film to 1000 fps. We can do this with the following command:

```bash
$ python create_movie.py touch-of-evil
```

The resulting npy file will be saved to the *movies/* folder. As you can run

```bash
$ python run_filternet.py config.simulation_touchofevil.json
```

To run FilterNet against 3 seconds of the 30 second clip and save the output to the *output_naturalmovie/* folder.

### Grey Screen

The `config.simulation_greyscreen.json` will run against of movie consisting of nothing but a static grey screen, which can be a useful check of our model. To generate the appropiate movie npy file run the following command

```bash
$ python create_movie.py greyscreen
```


