"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchControl = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const utils_1 = require("../../utils");
const useSigma_1 = require("../../hooks/useSigma");
const useCamera_1 = require("../../hooks/useCamera");
const useRegisterEvents_1 = require("../../hooks/useRegisterEvents");
const SearchControl = ({ id, className, style, labels = {}, }) => {
    const sigma = (0, useSigma_1.useSigma)();
    const registerEvents = (0, useRegisterEvents_1.useRegisterEvents)();
    const { gotoNode } = (0, useCamera_1.useCamera)();
    const [search, setSearch] = (0, react_1.useState)("");
    const [values, setValues] = (0, react_1.useState)([]);
    const [selected, setSelected] = (0, react_1.useState)(null);
    const [inputId, setInputId] = (0, react_1.useState)("");
    (0, react_1.useEffect)(() => {
        setInputId(`search-${(0, utils_1.getUniqueKey)()}`);
    }, []);
    (0, react_1.useEffect)(() => {
        const newValues = [];
        if (!selected && search.length > 1) {
            sigma.getGraph().forEachNode((key, attributes) => {
                if (attributes.label && attributes.label.toLowerCase().includes(search.toLowerCase()))
                    newValues.push({ id: key, label: attributes.label });
            });
        }
        setValues(newValues);
    }, [search]);
    (0, react_1.useEffect)(() => {
        registerEvents({
            clickStage: () => {
                setSelected(null);
                setSearch("");
            },
        });
    }, [registerEvents]);
    (0, react_1.useEffect)(() => {
        if (!selected) {
            return;
        }
        sigma.getGraph().setNodeAttribute(selected, "highlighted", true);
        gotoNode(selected);
        return () => {
            sigma.getGraph().setNodeAttribute(selected, "highlighted", false);
        };
    }, [selected]);
    const onInputChange = (e) => {
        const searchString = e.target.value;
        const valueItem = values.find((value) => value.label === searchString);
        if (valueItem) {
            setSearch(valueItem.label);
            setValues([]);
            setSelected(valueItem.id);
        }
        else {
            setSelected(null);
            setSearch(searchString);
        }
    };
    const htmlProps = {
        className: `react-sigma-search ${className ? className : ""}`,
        id,
        style,
    };
    return (react_1.default.createElement("div", Object.assign({}, htmlProps),
        react_1.default.createElement("label", { htmlFor: inputId, style: { display: "none" } }, labels["text"] || "Search a node"),
        react_1.default.createElement("input", { id: inputId, type: "text", placeholder: labels["placeholder"] || "Search...", list: `${inputId}-datalist`, value: search, onChange: onInputChange }),
        react_1.default.createElement("datalist", { id: `${inputId}-datalist` }, values.map((value) => (react_1.default.createElement("option", { key: value.id, value: value.label }, value.label))))));
};
exports.SearchControl = SearchControl;
//# sourceMappingURL=SearchControl.js.map