"use strict";

exports.__esModule = true;
exports.default = grammar;
// copyright: Copyright (c) 2024 Lowell D. Thomas, all rights reserved<br>
//   license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)<br>
//
// Generated by apg-js, Version 4.4.0 [apg-js](https://github.com/ldthomas/apg-js)
function grammar() {
  // ```
  // SUMMARY
  //      rules = 19
  //       udts = 0
  //    opcodes = 102
  //        ---   ABNF original opcodes
  //        ALT = 9
  //        CAT = 7
  //        REP = 11
  //        RNM = 31
  //        TLS = 41
  //        TBS = 0
  //        TRG = 3
  //        ---   SABNF superset opcodes
  //        UDT = 0
  //        AND = 0
  //        NOT = 0
  // characters = [33 - 126]
  // ```
  /* OBJECT IDENTIFIER (for internal parser use) */
  this.grammarObject = 'grammarObject';

  /* RULES */
  this.rules = [];
  this.rules[0] = {
    name: 'path-template',
    lower: 'path-template',
    index: 0,
    isBkr: false
  };
  this.rules[1] = {
    name: 'path',
    lower: 'path',
    index: 1,
    isBkr: false
  };
  this.rules[2] = {
    name: 'path-segment',
    lower: 'path-segment',
    index: 2,
    isBkr: false
  };
  this.rules[3] = {
    name: 'query',
    lower: 'query',
    index: 3,
    isBkr: false
  };
  this.rules[4] = {
    name: 'query-literal',
    lower: 'query-literal',
    index: 4,
    isBkr: false
  };
  this.rules[5] = {
    name: 'query-marker',
    lower: 'query-marker',
    index: 5,
    isBkr: false
  };
  this.rules[6] = {
    name: 'fragment',
    lower: 'fragment',
    index: 6,
    isBkr: false
  };
  this.rules[7] = {
    name: 'fragment-literal',
    lower: 'fragment-literal',
    index: 7,
    isBkr: false
  };
  this.rules[8] = {
    name: 'fragment-marker',
    lower: 'fragment-marker',
    index: 8,
    isBkr: false
  };
  this.rules[9] = {
    name: 'slash',
    lower: 'slash',
    index: 9,
    isBkr: false
  };
  this.rules[10] = {
    name: 'path-literal',
    lower: 'path-literal',
    index: 10,
    isBkr: false
  };
  this.rules[11] = {
    name: 'template-expression',
    lower: 'template-expression',
    index: 11,
    isBkr: false
  };
  this.rules[12] = {
    name: 'template-expression-param-name',
    lower: 'template-expression-param-name',
    index: 12,
    isBkr: false
  };
  this.rules[13] = {
    name: 'unreserved',
    lower: 'unreserved',
    index: 13,
    isBkr: false
  };
  this.rules[14] = {
    name: 'pct-encoded',
    lower: 'pct-encoded',
    index: 14,
    isBkr: false
  };
  this.rules[15] = {
    name: 'sub-delims',
    lower: 'sub-delims',
    index: 15,
    isBkr: false
  };
  this.rules[16] = {
    name: 'ALPHA',
    lower: 'alpha',
    index: 16,
    isBkr: false
  };
  this.rules[17] = {
    name: 'DIGIT',
    lower: 'digit',
    index: 17,
    isBkr: false
  };
  this.rules[18] = {
    name: 'HEXDIG',
    lower: 'hexdig',
    index: 18,
    isBkr: false
  };

  /* UDTS */
  this.udts = [];

  /* OPCODES */
  /* path-template */
  this.rules[0].opcodes = [];
  this.rules[0].opcodes[0] = {
    type: 2,
    children: [1, 2, 6]
  }; // CAT
  this.rules[0].opcodes[1] = {
    type: 4,
    index: 1
  }; // RNM(path)
  this.rules[0].opcodes[2] = {
    type: 3,
    min: 0,
    max: 1
  }; // REP
  this.rules[0].opcodes[3] = {
    type: 2,
    children: [4, 5]
  }; // CAT
  this.rules[0].opcodes[4] = {
    type: 4,
    index: 5
  }; // RNM(query-marker)
  this.rules[0].opcodes[5] = {
    type: 4,
    index: 3
  }; // RNM(query)
  this.rules[0].opcodes[6] = {
    type: 3,
    min: 0,
    max: 1
  }; // REP
  this.rules[0].opcodes[7] = {
    type: 2,
    children: [8, 9]
  }; // CAT
  this.rules[0].opcodes[8] = {
    type: 4,
    index: 8
  }; // RNM(fragment-marker)
  this.rules[0].opcodes[9] = {
    type: 4,
    index: 6
  }; // RNM(fragment)

  /* path */
  this.rules[1].opcodes = [];
  this.rules[1].opcodes[0] = {
    type: 2,
    children: [1, 2, 6]
  }; // CAT
  this.rules[1].opcodes[1] = {
    type: 4,
    index: 9
  }; // RNM(slash)
  this.rules[1].opcodes[2] = {
    type: 3,
    min: 0,
    max: Infinity
  }; // REP
  this.rules[1].opcodes[3] = {
    type: 2,
    children: [4, 5]
  }; // CAT
  this.rules[1].opcodes[4] = {
    type: 4,
    index: 2
  }; // RNM(path-segment)
  this.rules[1].opcodes[5] = {
    type: 4,
    index: 9
  }; // RNM(slash)
  this.rules[1].opcodes[6] = {
    type: 3,
    min: 0,
    max: 1
  }; // REP
  this.rules[1].opcodes[7] = {
    type: 4,
    index: 2
  }; // RNM(path-segment)

  /* path-segment */
  this.rules[2].opcodes = [];
  this.rules[2].opcodes[0] = {
    type: 3,
    min: 1,
    max: Infinity
  }; // REP
  this.rules[2].opcodes[1] = {
    type: 1,
    children: [2, 3]
  }; // ALT
  this.rules[2].opcodes[2] = {
    type: 4,
    index: 10
  }; // RNM(path-literal)
  this.rules[2].opcodes[3] = {
    type: 4,
    index: 11
  }; // RNM(template-expression)

  /* query */
  this.rules[3].opcodes = [];
  this.rules[3].opcodes[0] = {
    type: 3,
    min: 0,
    max: Infinity
  }; // REP
  this.rules[3].opcodes[1] = {
    type: 4,
    index: 4
  }; // RNM(query-literal)

  /* query-literal */
  this.rules[4].opcodes = [];
  this.rules[4].opcodes[0] = {
    type: 3,
    min: 1,
    max: Infinity
  }; // REP
  this.rules[4].opcodes[1] = {
    type: 1,
    children: [2, 3, 4, 5, 6, 7, 8, 9, 10]
  }; // ALT
  this.rules[4].opcodes[2] = {
    type: 4,
    index: 13
  }; // RNM(unreserved)
  this.rules[4].opcodes[3] = {
    type: 4,
    index: 14
  }; // RNM(pct-encoded)
  this.rules[4].opcodes[4] = {
    type: 4,
    index: 15
  }; // RNM(sub-delims)
  this.rules[4].opcodes[5] = {
    type: 7,
    string: [58]
  }; // TLS
  this.rules[4].opcodes[6] = {
    type: 7,
    string: [64]
  }; // TLS
  this.rules[4].opcodes[7] = {
    type: 7,
    string: [47]
  }; // TLS
  this.rules[4].opcodes[8] = {
    type: 7,
    string: [63]
  }; // TLS
  this.rules[4].opcodes[9] = {
    type: 7,
    string: [38]
  }; // TLS
  this.rules[4].opcodes[10] = {
    type: 7,
    string: [61]
  }; // TLS

  /* query-marker */
  this.rules[5].opcodes = [];
  this.rules[5].opcodes[0] = {
    type: 7,
    string: [63]
  }; // TLS

  /* fragment */
  this.rules[6].opcodes = [];
  this.rules[6].opcodes[0] = {
    type: 3,
    min: 0,
    max: Infinity
  }; // REP
  this.rules[6].opcodes[1] = {
    type: 4,
    index: 7
  }; // RNM(fragment-literal)

  /* fragment-literal */
  this.rules[7].opcodes = [];
  this.rules[7].opcodes[0] = {
    type: 3,
    min: 1,
    max: Infinity
  }; // REP
  this.rules[7].opcodes[1] = {
    type: 1,
    children: [2, 3, 4, 5, 6, 7, 8]
  }; // ALT
  this.rules[7].opcodes[2] = {
    type: 4,
    index: 13
  }; // RNM(unreserved)
  this.rules[7].opcodes[3] = {
    type: 4,
    index: 14
  }; // RNM(pct-encoded)
  this.rules[7].opcodes[4] = {
    type: 4,
    index: 15
  }; // RNM(sub-delims)
  this.rules[7].opcodes[5] = {
    type: 7,
    string: [58]
  }; // TLS
  this.rules[7].opcodes[6] = {
    type: 7,
    string: [64]
  }; // TLS
  this.rules[7].opcodes[7] = {
    type: 7,
    string: [47]
  }; // TLS
  this.rules[7].opcodes[8] = {
    type: 7,
    string: [63]
  }; // TLS

  /* fragment-marker */
  this.rules[8].opcodes = [];
  this.rules[8].opcodes[0] = {
    type: 7,
    string: [35]
  }; // TLS

  /* slash */
  this.rules[9].opcodes = [];
  this.rules[9].opcodes[0] = {
    type: 7,
    string: [47]
  }; // TLS

  /* path-literal */
  this.rules[10].opcodes = [];
  this.rules[10].opcodes[0] = {
    type: 3,
    min: 1,
    max: Infinity
  }; // REP
  this.rules[10].opcodes[1] = {
    type: 1,
    children: [2, 3, 4, 5, 6]
  }; // ALT
  this.rules[10].opcodes[2] = {
    type: 4,
    index: 13
  }; // RNM(unreserved)
  this.rules[10].opcodes[3] = {
    type: 4,
    index: 14
  }; // RNM(pct-encoded)
  this.rules[10].opcodes[4] = {
    type: 4,
    index: 15
  }; // RNM(sub-delims)
  this.rules[10].opcodes[5] = {
    type: 7,
    string: [58]
  }; // TLS
  this.rules[10].opcodes[6] = {
    type: 7,
    string: [64]
  }; // TLS

  /* template-expression */
  this.rules[11].opcodes = [];
  this.rules[11].opcodes[0] = {
    type: 2,
    children: [1, 2, 3]
  }; // CAT
  this.rules[11].opcodes[1] = {
    type: 7,
    string: [123]
  }; // TLS
  this.rules[11].opcodes[2] = {
    type: 4,
    index: 12
  }; // RNM(template-expression-param-name)
  this.rules[11].opcodes[3] = {
    type: 7,
    string: [125]
  }; // TLS

  /* template-expression-param-name */
  this.rules[12].opcodes = [];
  this.rules[12].opcodes[0] = {
    type: 3,
    min: 1,
    max: Infinity
  }; // REP
  this.rules[12].opcodes[1] = {
    type: 1,
    children: [2, 3, 4, 5, 6]
  }; // ALT
  this.rules[12].opcodes[2] = {
    type: 4,
    index: 13
  }; // RNM(unreserved)
  this.rules[12].opcodes[3] = {
    type: 4,
    index: 14
  }; // RNM(pct-encoded)
  this.rules[12].opcodes[4] = {
    type: 4,
    index: 15
  }; // RNM(sub-delims)
  this.rules[12].opcodes[5] = {
    type: 7,
    string: [58]
  }; // TLS
  this.rules[12].opcodes[6] = {
    type: 7,
    string: [64]
  }; // TLS

  /* unreserved */
  this.rules[13].opcodes = [];
  this.rules[13].opcodes[0] = {
    type: 1,
    children: [1, 2, 3, 4, 5, 6]
  }; // ALT
  this.rules[13].opcodes[1] = {
    type: 4,
    index: 16
  }; // RNM(ALPHA)
  this.rules[13].opcodes[2] = {
    type: 4,
    index: 17
  }; // RNM(DIGIT)
  this.rules[13].opcodes[3] = {
    type: 7,
    string: [45]
  }; // TLS
  this.rules[13].opcodes[4] = {
    type: 7,
    string: [46]
  }; // TLS
  this.rules[13].opcodes[5] = {
    type: 7,
    string: [95]
  }; // TLS
  this.rules[13].opcodes[6] = {
    type: 7,
    string: [126]
  }; // TLS

  /* pct-encoded */
  this.rules[14].opcodes = [];
  this.rules[14].opcodes[0] = {
    type: 2,
    children: [1, 2, 3]
  }; // CAT
  this.rules[14].opcodes[1] = {
    type: 7,
    string: [37]
  }; // TLS
  this.rules[14].opcodes[2] = {
    type: 4,
    index: 18
  }; // RNM(HEXDIG)
  this.rules[14].opcodes[3] = {
    type: 4,
    index: 18
  }; // RNM(HEXDIG)

  /* sub-delims */
  this.rules[15].opcodes = [];
  this.rules[15].opcodes[0] = {
    type: 1,
    children: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
  }; // ALT
  this.rules[15].opcodes[1] = {
    type: 7,
    string: [33]
  }; // TLS
  this.rules[15].opcodes[2] = {
    type: 7,
    string: [36]
  }; // TLS
  this.rules[15].opcodes[3] = {
    type: 7,
    string: [38]
  }; // TLS
  this.rules[15].opcodes[4] = {
    type: 7,
    string: [39]
  }; // TLS
  this.rules[15].opcodes[5] = {
    type: 7,
    string: [40]
  }; // TLS
  this.rules[15].opcodes[6] = {
    type: 7,
    string: [41]
  }; // TLS
  this.rules[15].opcodes[7] = {
    type: 7,
    string: [42]
  }; // TLS
  this.rules[15].opcodes[8] = {
    type: 7,
    string: [43]
  }; // TLS
  this.rules[15].opcodes[9] = {
    type: 7,
    string: [44]
  }; // TLS
  this.rules[15].opcodes[10] = {
    type: 7,
    string: [59]
  }; // TLS
  this.rules[15].opcodes[11] = {
    type: 7,
    string: [61]
  }; // TLS

  /* ALPHA */
  this.rules[16].opcodes = [];
  this.rules[16].opcodes[0] = {
    type: 1,
    children: [1, 2]
  }; // ALT
  this.rules[16].opcodes[1] = {
    type: 5,
    min: 65,
    max: 90
  }; // TRG
  this.rules[16].opcodes[2] = {
    type: 5,
    min: 97,
    max: 122
  }; // TRG

  /* DIGIT */
  this.rules[17].opcodes = [];
  this.rules[17].opcodes[0] = {
    type: 5,
    min: 48,
    max: 57
  }; // TRG

  /* HEXDIG */
  this.rules[18].opcodes = [];
  this.rules[18].opcodes[0] = {
    type: 1,
    children: [1, 2, 3, 4, 5, 6, 7]
  }; // ALT
  this.rules[18].opcodes[1] = {
    type: 4,
    index: 17
  }; // RNM(DIGIT)
  this.rules[18].opcodes[2] = {
    type: 7,
    string: [97]
  }; // TLS
  this.rules[18].opcodes[3] = {
    type: 7,
    string: [98]
  }; // TLS
  this.rules[18].opcodes[4] = {
    type: 7,
    string: [99]
  }; // TLS
  this.rules[18].opcodes[5] = {
    type: 7,
    string: [100]
  }; // TLS
  this.rules[18].opcodes[6] = {
    type: 7,
    string: [101]
  }; // TLS
  this.rules[18].opcodes[7] = {
    type: 7,
    string: [102]
  }; // TLS

  // The `toString()` function will display the original grammar file(s) that produced these opcodes.
  this.toString = function toString() {
    let str = "";
    str += "; OpenAPI Path Templating ABNF syntax\n";
    str += "path-template                  = path [ query-marker query ] [ fragment-marker fragment ]\n";
    str += "path                           = slash *( path-segment slash ) [ path-segment ]\n";
    str += "path-segment                   = 1*( path-literal / template-expression )\n";
    str += "query                          = *( query-literal )\n";
    str += "query-literal                  = 1*( unreserved / pct-encoded / sub-delims / \":\" / \"@\" / \"/\" / \"?\" / \"&\" / \"=\" )\n";
    str += "query-marker                   = \"?\"\n";
    str += "fragment                       = *( fragment-literal )\n";
    str += "fragment-literal               = 1*( unreserved / pct-encoded / sub-delims / \":\" / \"@\" / \"/\" / \"?\" )\n";
    str += "fragment-marker                = \"#\"\n";
    str += "slash                          = \"/\"\n";
    str += "path-literal                   = 1*( unreserved / pct-encoded / sub-delims / \":\" / \"@\" )\n";
    str += "template-expression            = \"{\" template-expression-param-name \"}\"\n";
    str += "template-expression-param-name = 1*( unreserved / pct-encoded / sub-delims / \":\" / \"@\" )\n";
    str += "\n";
    str += "; Characters definitions (from RFC 3986)\n";
    str += "unreserved          = ALPHA / DIGIT / \"-\" / \".\" / \"_\" / \"~\"\n";
    str += "pct-encoded         = \"%\" HEXDIG HEXDIG\n";
    str += "sub-delims          = \"!\" / \"$\" / \"&\" / \"'\" / \"(\" / \")\"\n";
    str += "                    / \"*\" / \"+\" / \",\" / \";\" / \"=\"\n";
    str += "ALPHA               = %x41-5A / %x61-7A   ; A-Z / a-z\n";
    str += "DIGIT               = %x30-39            ; 0-9\n";
    str += "HEXDIG              = DIGIT / \"A\" / \"B\" / \"C\" / \"D\" / \"E\" / \"F\"\n";
    return str;
  };
}