import * as React from 'react';
/**
 * @ignore - internal component.
 */
const Context = /*#__PURE__*/React.createContext(null);
if (process.env.NODE_ENV !== 'production') {
  Context.displayName = 'TabsContext';
}
export function useTabsContext() {
  const context = React.useContext(Context);
  if (context == null) {
    throw new Error('No TabsContext provided');
  }
  return context;
}
export default Context;