"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var CypherTypes = _interopRequireWildcard(require("../../lang/CypherTypes"));
var CompletionTypes = _interopRequireWildcard(require("../CompletionTypes"));
var _TreeUtils = require("../../util/TreeUtils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const childToParentTypeMapping = new Map();
childToParentTypeMapping.set(CypherTypes.VARIABLE_CONTEXT, [{
  type: CompletionTypes.VARIABLE
}]);
childToParentTypeMapping.set(CypherTypes.PARAMETER_NAME_CONTEXT, [{
  type: CompletionTypes.PARAMETER
}]);
childToParentTypeMapping.set(CypherTypes.PROPERTY_KEY_NAME_CONTEXT, [{
  type: CompletionTypes.PROPERTY_KEY
}]);
childToParentTypeMapping.set(CypherTypes.FUNCTION_NAME_CONTEXT, [{
  type: CompletionTypes.FUNCTION_NAME
}]);
childToParentTypeMapping.set(CypherTypes.PROCEDURE_NAME_CONTEXT, [{
  type: CompletionTypes.PROCEDURE_NAME
}]);
childToParentTypeMapping.set(CypherTypes.NODE_LABEL_CONTEXT, [{
  type: CompletionTypes.LABEL
}]);
childToParentTypeMapping.set(CypherTypes.RELATIONSHIP_TYPE_CONTEXT, [{
  type: CompletionTypes.RELATIONSHIP_TYPE
}]);
childToParentTypeMapping.set(CypherTypes.RELATIONSHIP_TYPE_OPTIONAL_COLON_CONTEXT, [{
  type: CompletionTypes.RELATIONSHIP_TYPE
}]);
childToParentTypeMapping.set(CypherTypes.CONSOLE_COMMAND_NAME_CONTEXT, [{
  type: CompletionTypes.CONSOLE_COMMAND_NAME
}]);
childToParentTypeMapping.set(CypherTypes.NODE_LABELS_CONTEXT, [{
  type: CompletionTypes.LABEL
}]);
childToParentTypeMapping.set(CypherTypes.RELATIONSHIP_TYPES_CONTEXT, [{
  type: CompletionTypes.RELATIONSHIP_TYPE
}]);

// Check that element is inside specific parent context
var _default = element => {
  const parent = _TreeUtils.TreeUtils.findAnyParent(element, Array.from(childToParentTypeMapping.keys()));
  return parent != null ? childToParentTypeMapping.get(parent.constructor) : [];
};
exports.default = _default;