"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompletionTypeResolver = void 0;
var CompletionTypes = _interopRequireWildcard(require("./CompletionTypes"));
var rules = _interopRequireWildcard(require("./rules"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// Rules are sorted starting with specific ones, and finishing with more generic ones.
const orderedCompletionRules = [rules.ruleNoop, rules.ruleVariableInExpressionPossibleFunction, rules.ruleLiteralEntry, rules.rulePropInMapLiteral, rules.ruleParamStartsWithDollar, rules.ruleSpecificParent, rules.ruleNodePattern, rules.ruleRelationshipPattern, rules.ruleProcedureOutputsInCallClause, rules.ruleCallClauseBeginning, rules.ruleConsoleCommandSubcommands, rules.rulePropertyLookup, rules.rulePossibleKeyword];
function evaluateRules(element) {
  for (let i = 0; i < orderedCompletionRules.length; i += 1) {
    const rule = orderedCompletionRules[i];
    const types = rule(element);
    if (types.length > 0) {
      return types;
    }
  }
  return [];
}
class CompletionTypeResolver {
  static getTypes(element) {
    // If element is null, then no types
    if (element == null) {
      return {
        found: false,
        types: CompletionTypes.ALL
      };
    }

    // Retrieve types from rules
    const types = evaluateRules(element);
    if (types.length > 0) {
      return {
        found: true,
        types
      };
    }

    // If no types found, then no types
    return {
      found: false,
      types: CompletionTypes.ALL
    };
  }
}
exports.CompletionTypeResolver = CompletionTypeResolver;