/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2018-2019 Erik Moqvist
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/**
 * This file was generated by asn1tools version 0.162.0 Fri May  6 17:18:21 2022.
 */

#include <string.h>

#include "uper.h"

struct encoder_t {
    uint8_t *buf_p;
    ssize_t size;
    ssize_t pos;
};

struct decoder_t {
    const uint8_t *buf_p;
    ssize_t size;
    ssize_t pos;
};

static void encoder_init(struct encoder_t *self_p,
                         uint8_t *buf_p,
                         size_t size)
{
    self_p->buf_p = buf_p;
    self_p->size = (8 * (ssize_t)size);
    self_p->pos = 0;
}

static ssize_t encoder_get_result(const struct encoder_t *self_p)
{
    if (self_p->size >= 0) {
        return ((self_p->pos + 7) / 8);
    } else {
        return (self_p->pos);
    }
}

static void encoder_abort(struct encoder_t *self_p,
                          ssize_t error)
{
    if (self_p->size >= 0) {
        self_p->size = -error;
        self_p->pos = -error;
    }
}

static ssize_t encoder_alloc(struct encoder_t *self_p,
                             size_t size)
{
    ssize_t pos;

    if ((self_p->pos + (ssize_t)size) <= self_p->size) {
        pos = self_p->pos;
        self_p->pos += (ssize_t)size;
    } else {
        pos = -ENOMEM;
        encoder_abort(self_p, ENOMEM);
    }

    return (pos);
}

static void encoder_append_bit(struct encoder_t *self_p,
                               int value)
{
    ssize_t pos;

    pos = encoder_alloc(self_p, 1);

    if (pos < 0) {
        return;
    }

    if ((pos % 8) == 0) {
        self_p->buf_p[pos / 8] = 0;
    }

    self_p->buf_p[pos / 8] |= (uint8_t)(value << (7 - (pos % 8)));
}

static void encoder_append_bytes(struct encoder_t *self_p,
                                 const uint8_t *buf_p,
                                 size_t size)
{
    size_t i;
    ssize_t pos;
    size_t byte_pos;
    size_t pos_in_byte;

    pos = encoder_alloc(self_p, 8u * size);

    if (pos < 0) {
        return;
    }

    byte_pos = ((size_t)pos / 8u);
    pos_in_byte = ((size_t)pos % 8u);

    if (pos_in_byte == 0u) {
        (void)memcpy(&self_p->buf_p[byte_pos], buf_p, size);
    } else {
        for (i = 0; i < size; i++) {
            self_p->buf_p[byte_pos + i] |= (buf_p[i] >> pos_in_byte);
            self_p->buf_p[byte_pos + i + 1] = (buf_p[i] << (8u - pos_in_byte));
        }
    }
}

static void encoder_append_uint8(struct encoder_t *self_p,
                                 uint8_t value)
{
    uint8_t buf[1];

    buf[0] = (uint8_t)value;

    encoder_append_bytes(self_p, &buf[0], sizeof(buf));
}

static void encoder_append_uint16(struct encoder_t *self_p,
                                  uint16_t value)
{
    uint8_t buf[2];

    buf[0] = (uint8_t)(value >> 8);
    buf[1] = (uint8_t)value;

    encoder_append_bytes(self_p, &buf[0], sizeof(buf));
}

static void encoder_append_uint32(struct encoder_t *self_p,
                                  uint32_t value)
{
    uint8_t buf[4];

    buf[0] = (uint8_t)(value >> 24);
    buf[1] = (uint8_t)(value >> 16);
    buf[2] = (uint8_t)(value >> 8);
    buf[3] = (uint8_t)value;

    encoder_append_bytes(self_p, &buf[0], sizeof(buf));
}

static void encoder_append_uint64(struct encoder_t *self_p,
                                  uint64_t value)
{
    uint8_t buf[8];

    buf[0] = (uint8_t)(value >> 56);
    buf[1] = (uint8_t)(value >> 48);
    buf[2] = (uint8_t)(value >> 40);
    buf[3] = (uint8_t)(value >> 32);
    buf[4] = (uint8_t)(value >> 24);
    buf[5] = (uint8_t)(value >> 16);
    buf[6] = (uint8_t)(value >> 8);
    buf[7] = (uint8_t)value;

    encoder_append_bytes(self_p, &buf[0], sizeof(buf));
}

static void encoder_append_int8(struct encoder_t *self_p,
                                int8_t value)
{
    encoder_append_uint8(self_p, (uint8_t)value + 128);
}

static void encoder_append_int16(struct encoder_t *self_p,
                                 int16_t value)
{
    encoder_append_uint16(self_p, (uint16_t)value + 32768);
}

static void encoder_append_int32(struct encoder_t *self_p,
                                 int32_t value)
{
    encoder_append_uint32(self_p, (uint32_t)value + 2147483648);
}

static void encoder_append_int64(struct encoder_t *self_p,
                                 int64_t value)
{
    uint64_t u64_value;

    u64_value = (uint64_t)value;
    u64_value += 9223372036854775808ull;

    encoder_append_uint64(self_p, u64_value);
}

static void encoder_append_bool(struct encoder_t *self_p, bool value)
{
    encoder_append_bit(self_p, value ? 1 : 0);
}

static void encoder_append_non_negative_binary_integer(struct encoder_t *self_p,
                                                       uint64_t value,
                                                       size_t size)
{
    size_t i;

    for (i = 0; i < size; i++) {
        encoder_append_bit(self_p, (value >> (size - i - 1)) & 1);
    }
}

static void decoder_init(struct decoder_t *self_p,
                         const uint8_t *buf_p,
                         size_t size)
{
    self_p->buf_p = buf_p;
    self_p->size = (8 * (ssize_t)size);
    self_p->pos = 0;
}

static ssize_t decoder_get_result(const struct decoder_t *self_p)
{
    if (self_p->size >= 0) {
        return ((self_p->pos + 7) / 8);
    } else {
        return (self_p->pos);
    }
}

static void decoder_abort(struct decoder_t *self_p,
                          ssize_t error)
{
    if (self_p->size >= 0) {
        self_p->size = -error;
        self_p->pos = -error;
    }
}

static ssize_t decoder_free(struct decoder_t *self_p,
                            size_t size)
{
    ssize_t pos;

    if ((self_p->pos + (ssize_t)size) <= self_p->size) {
        pos = self_p->pos;
        self_p->pos += (ssize_t)size;
    } else {
        pos = -EOUTOFDATA;
        decoder_abort(self_p, EOUTOFDATA);
    }

    return (pos);
}

static int decoder_read_bit(struct decoder_t *self_p)
{
    ssize_t pos;
    int value;

    pos = decoder_free(self_p, 1);

    if (pos >= 0) {
        value = ((self_p->buf_p[pos / 8] >> (7 - (pos % 8))) & 1);
    } else {
        value = 0;
    }

    return (value);
}

static void decoder_read_bytes(struct decoder_t *self_p,
                               uint8_t *buf_p,
                               size_t size)
{
    size_t i;
    ssize_t pos;
    size_t byte_pos;
    size_t pos_in_byte;

    pos = decoder_free(self_p, 8u * size);

    if (pos < 0) {
        return;
    }

    byte_pos = ((size_t)pos / 8u);
    pos_in_byte = ((size_t)pos % 8u);

    if (pos_in_byte == 0) {
        (void)memcpy(buf_p, &self_p->buf_p[byte_pos], size);
    } else {
        for (i = 0; i < size; i++) {
            buf_p[i] = (self_p->buf_p[byte_pos + i] << pos_in_byte);
            buf_p[i] |= (self_p->buf_p[byte_pos + i + 1] >> (8u - pos_in_byte));
        }
    }
}

static uint8_t decoder_read_uint8(struct decoder_t *self_p)
{
    uint8_t value;

    decoder_read_bytes(self_p, &value, sizeof(value));

    return (value);
}

static uint16_t decoder_read_uint16(struct decoder_t *self_p)
{
    uint8_t buf[2];

    decoder_read_bytes(self_p, &buf[0], sizeof(buf));

    return (((uint16_t)buf[0] << 8) | (uint16_t)buf[1]);
}

static uint32_t decoder_read_uint32(struct decoder_t *self_p)
{
    uint8_t buf[4];

    decoder_read_bytes(self_p, &buf[0], sizeof(buf));

    return (((uint32_t)buf[0] << 24)
            | ((uint32_t)buf[1] << 16)
            | ((uint32_t)buf[2] << 8)
            | (uint32_t)buf[3]);
}

static uint64_t decoder_read_uint64(struct decoder_t *self_p)
{
    uint8_t buf[8];

    decoder_read_bytes(self_p, &buf[0], sizeof(buf));

    return (((uint64_t)buf[0] << 56)
            | ((uint64_t)buf[1] << 48)
            | ((uint64_t)buf[2] << 40)
            | ((uint64_t)buf[3] << 32)
            | ((uint64_t)buf[4] << 24)
            | ((uint64_t)buf[5] << 16)
            | ((uint64_t)buf[6] << 8)
            | (uint64_t)buf[7]);
}

static int8_t decoder_read_int8(struct decoder_t *self_p)
{
    int8_t value;

    value = (int8_t)decoder_read_uint8(self_p);
    value -= 128;

    return (value);
}

static int16_t decoder_read_int16(struct decoder_t *self_p)
{
    int16_t value;

    value = (int16_t)decoder_read_uint16(self_p);
    value -= 32768;

    return (value);
}

static int32_t decoder_read_int32(struct decoder_t *self_p)
{
    int32_t value;

    value = (int32_t)decoder_read_uint32(self_p);
    value -= 2147483648;

    return (value);
}

static int64_t decoder_read_int64(struct decoder_t *self_p)
{
    uint64_t value;

    value = decoder_read_uint64(self_p);
    value -= 9223372036854775808ull;

    return ((int64_t)value);
}

static bool decoder_read_bool(struct decoder_t *self_p)
{
    return (decoder_read_bit(self_p) != 0);
}

static uint64_t decoder_read_non_negative_binary_integer(struct decoder_t *self_p,
                                                         size_t size)
{
    size_t i;
    uint64_t value;

    value = 0;

    for (i = 0; i < size; i++) {
        value <<= 1;
        value |= (uint64_t)decoder_read_bit(self_p);
    }

    return (value);
}

static void uper_c_source_a_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_a_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->a);
    encoder_append_int16(encoder_p, src_p->b);
    encoder_append_int32(encoder_p, src_p->c);
    encoder_append_int64(encoder_p, src_p->d);
    encoder_append_uint8(encoder_p, src_p->e);
    encoder_append_uint16(encoder_p, src_p->f);
    encoder_append_uint32(encoder_p, src_p->g);
    encoder_append_uint64(encoder_p, src_p->h);
    encoder_append_bool(encoder_p, src_p->i);
    encoder_append_bytes(encoder_p,
                         &src_p->j.buf[0],
                         11);
}

static void uper_c_source_a_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_a_t *dst_p)
{
    dst_p->a = decoder_read_int8(decoder_p);
    dst_p->b = decoder_read_int16(decoder_p);
    dst_p->c = decoder_read_int32(decoder_p);
    dst_p->d = decoder_read_int64(decoder_p);
    dst_p->e = decoder_read_uint8(decoder_p);
    dst_p->f = decoder_read_uint16(decoder_p);
    dst_p->g = decoder_read_uint32(decoder_p);
    dst_p->h = decoder_read_uint64(decoder_p);
    dst_p->i = decoder_read_bool(decoder_p);
    decoder_read_bytes(decoder_p,
                       &dst_p->j.buf[0],
                       11);
}

static void uper_c_source_ab_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ab_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->a - -1),
        1);
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->b - 10000),
        10);
}

static void uper_c_source_ab_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ab_t *dst_p)
{
    dst_p->a = decoder_read_non_negative_binary_integer(
        decoder_p,
        1);
    dst_p->a += -1;
    dst_p->b = decoder_read_non_negative_binary_integer(
        decoder_p,
        10);
    dst_p->b += 10000;
}

static void uper_c_source_q_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_q_t *src_p)
{
    switch (src_p->choice) {

    case uper_c_source_q_choice_c001_e:
        encoder_append_non_negative_binary_integer(encoder_p, 0, 9);
        encoder_append_bool(encoder_p, src_p->value.c001);
        break;

    case uper_c_source_q_choice_c002_e:
        encoder_append_non_negative_binary_integer(encoder_p, 1, 9);
        encoder_append_bool(encoder_p, src_p->value.c002);
        break;

    case uper_c_source_q_choice_c003_e:
        encoder_append_non_negative_binary_integer(encoder_p, 2, 9);
        encoder_append_bool(encoder_p, src_p->value.c003);
        break;

    case uper_c_source_q_choice_c004_e:
        encoder_append_non_negative_binary_integer(encoder_p, 3, 9);
        encoder_append_bool(encoder_p, src_p->value.c004);
        break;

    case uper_c_source_q_choice_c005_e:
        encoder_append_non_negative_binary_integer(encoder_p, 4, 9);
        encoder_append_bool(encoder_p, src_p->value.c005);
        break;

    case uper_c_source_q_choice_c006_e:
        encoder_append_non_negative_binary_integer(encoder_p, 5, 9);
        encoder_append_bool(encoder_p, src_p->value.c006);
        break;

    case uper_c_source_q_choice_c007_e:
        encoder_append_non_negative_binary_integer(encoder_p, 6, 9);
        encoder_append_bool(encoder_p, src_p->value.c007);
        break;

    case uper_c_source_q_choice_c008_e:
        encoder_append_non_negative_binary_integer(encoder_p, 7, 9);
        encoder_append_bool(encoder_p, src_p->value.c008);
        break;

    case uper_c_source_q_choice_c009_e:
        encoder_append_non_negative_binary_integer(encoder_p, 8, 9);
        encoder_append_bool(encoder_p, src_p->value.c009);
        break;

    case uper_c_source_q_choice_c010_e:
        encoder_append_non_negative_binary_integer(encoder_p, 9, 9);
        encoder_append_bool(encoder_p, src_p->value.c010);
        break;

    case uper_c_source_q_choice_c011_e:
        encoder_append_non_negative_binary_integer(encoder_p, 10, 9);
        encoder_append_bool(encoder_p, src_p->value.c011);
        break;

    case uper_c_source_q_choice_c012_e:
        encoder_append_non_negative_binary_integer(encoder_p, 11, 9);
        encoder_append_bool(encoder_p, src_p->value.c012);
        break;

    case uper_c_source_q_choice_c013_e:
        encoder_append_non_negative_binary_integer(encoder_p, 12, 9);
        encoder_append_bool(encoder_p, src_p->value.c013);
        break;

    case uper_c_source_q_choice_c014_e:
        encoder_append_non_negative_binary_integer(encoder_p, 13, 9);
        encoder_append_bool(encoder_p, src_p->value.c014);
        break;

    case uper_c_source_q_choice_c015_e:
        encoder_append_non_negative_binary_integer(encoder_p, 14, 9);
        encoder_append_bool(encoder_p, src_p->value.c015);
        break;

    case uper_c_source_q_choice_c016_e:
        encoder_append_non_negative_binary_integer(encoder_p, 15, 9);
        encoder_append_bool(encoder_p, src_p->value.c016);
        break;

    case uper_c_source_q_choice_c017_e:
        encoder_append_non_negative_binary_integer(encoder_p, 16, 9);
        encoder_append_bool(encoder_p, src_p->value.c017);
        break;

    case uper_c_source_q_choice_c018_e:
        encoder_append_non_negative_binary_integer(encoder_p, 17, 9);
        encoder_append_bool(encoder_p, src_p->value.c018);
        break;

    case uper_c_source_q_choice_c019_e:
        encoder_append_non_negative_binary_integer(encoder_p, 18, 9);
        encoder_append_bool(encoder_p, src_p->value.c019);
        break;

    case uper_c_source_q_choice_c020_e:
        encoder_append_non_negative_binary_integer(encoder_p, 19, 9);
        encoder_append_bool(encoder_p, src_p->value.c020);
        break;

    case uper_c_source_q_choice_c021_e:
        encoder_append_non_negative_binary_integer(encoder_p, 20, 9);
        encoder_append_bool(encoder_p, src_p->value.c021);
        break;

    case uper_c_source_q_choice_c022_e:
        encoder_append_non_negative_binary_integer(encoder_p, 21, 9);
        encoder_append_bool(encoder_p, src_p->value.c022);
        break;

    case uper_c_source_q_choice_c023_e:
        encoder_append_non_negative_binary_integer(encoder_p, 22, 9);
        encoder_append_bool(encoder_p, src_p->value.c023);
        break;

    case uper_c_source_q_choice_c024_e:
        encoder_append_non_negative_binary_integer(encoder_p, 23, 9);
        encoder_append_bool(encoder_p, src_p->value.c024);
        break;

    case uper_c_source_q_choice_c025_e:
        encoder_append_non_negative_binary_integer(encoder_p, 24, 9);
        encoder_append_bool(encoder_p, src_p->value.c025);
        break;

    case uper_c_source_q_choice_c026_e:
        encoder_append_non_negative_binary_integer(encoder_p, 25, 9);
        encoder_append_bool(encoder_p, src_p->value.c026);
        break;

    case uper_c_source_q_choice_c027_e:
        encoder_append_non_negative_binary_integer(encoder_p, 26, 9);
        encoder_append_bool(encoder_p, src_p->value.c027);
        break;

    case uper_c_source_q_choice_c028_e:
        encoder_append_non_negative_binary_integer(encoder_p, 27, 9);
        encoder_append_bool(encoder_p, src_p->value.c028);
        break;

    case uper_c_source_q_choice_c029_e:
        encoder_append_non_negative_binary_integer(encoder_p, 28, 9);
        encoder_append_bool(encoder_p, src_p->value.c029);
        break;

    case uper_c_source_q_choice_c030_e:
        encoder_append_non_negative_binary_integer(encoder_p, 29, 9);
        encoder_append_bool(encoder_p, src_p->value.c030);
        break;

    case uper_c_source_q_choice_c031_e:
        encoder_append_non_negative_binary_integer(encoder_p, 30, 9);
        encoder_append_bool(encoder_p, src_p->value.c031);
        break;

    case uper_c_source_q_choice_c032_e:
        encoder_append_non_negative_binary_integer(encoder_p, 31, 9);
        encoder_append_bool(encoder_p, src_p->value.c032);
        break;

    case uper_c_source_q_choice_c033_e:
        encoder_append_non_negative_binary_integer(encoder_p, 32, 9);
        encoder_append_bool(encoder_p, src_p->value.c033);
        break;

    case uper_c_source_q_choice_c034_e:
        encoder_append_non_negative_binary_integer(encoder_p, 33, 9);
        encoder_append_bool(encoder_p, src_p->value.c034);
        break;

    case uper_c_source_q_choice_c035_e:
        encoder_append_non_negative_binary_integer(encoder_p, 34, 9);
        encoder_append_bool(encoder_p, src_p->value.c035);
        break;

    case uper_c_source_q_choice_c036_e:
        encoder_append_non_negative_binary_integer(encoder_p, 35, 9);
        encoder_append_bool(encoder_p, src_p->value.c036);
        break;

    case uper_c_source_q_choice_c037_e:
        encoder_append_non_negative_binary_integer(encoder_p, 36, 9);
        encoder_append_bool(encoder_p, src_p->value.c037);
        break;

    case uper_c_source_q_choice_c038_e:
        encoder_append_non_negative_binary_integer(encoder_p, 37, 9);
        encoder_append_bool(encoder_p, src_p->value.c038);
        break;

    case uper_c_source_q_choice_c039_e:
        encoder_append_non_negative_binary_integer(encoder_p, 38, 9);
        encoder_append_bool(encoder_p, src_p->value.c039);
        break;

    case uper_c_source_q_choice_c040_e:
        encoder_append_non_negative_binary_integer(encoder_p, 39, 9);
        encoder_append_bool(encoder_p, src_p->value.c040);
        break;

    case uper_c_source_q_choice_c041_e:
        encoder_append_non_negative_binary_integer(encoder_p, 40, 9);
        encoder_append_bool(encoder_p, src_p->value.c041);
        break;

    case uper_c_source_q_choice_c042_e:
        encoder_append_non_negative_binary_integer(encoder_p, 41, 9);
        encoder_append_bool(encoder_p, src_p->value.c042);
        break;

    case uper_c_source_q_choice_c043_e:
        encoder_append_non_negative_binary_integer(encoder_p, 42, 9);
        encoder_append_bool(encoder_p, src_p->value.c043);
        break;

    case uper_c_source_q_choice_c044_e:
        encoder_append_non_negative_binary_integer(encoder_p, 43, 9);
        encoder_append_bool(encoder_p, src_p->value.c044);
        break;

    case uper_c_source_q_choice_c045_e:
        encoder_append_non_negative_binary_integer(encoder_p, 44, 9);
        encoder_append_bool(encoder_p, src_p->value.c045);
        break;

    case uper_c_source_q_choice_c046_e:
        encoder_append_non_negative_binary_integer(encoder_p, 45, 9);
        encoder_append_bool(encoder_p, src_p->value.c046);
        break;

    case uper_c_source_q_choice_c047_e:
        encoder_append_non_negative_binary_integer(encoder_p, 46, 9);
        encoder_append_bool(encoder_p, src_p->value.c047);
        break;

    case uper_c_source_q_choice_c048_e:
        encoder_append_non_negative_binary_integer(encoder_p, 47, 9);
        encoder_append_bool(encoder_p, src_p->value.c048);
        break;

    case uper_c_source_q_choice_c049_e:
        encoder_append_non_negative_binary_integer(encoder_p, 48, 9);
        encoder_append_bool(encoder_p, src_p->value.c049);
        break;

    case uper_c_source_q_choice_c050_e:
        encoder_append_non_negative_binary_integer(encoder_p, 49, 9);
        encoder_append_bool(encoder_p, src_p->value.c050);
        break;

    case uper_c_source_q_choice_c051_e:
        encoder_append_non_negative_binary_integer(encoder_p, 50, 9);
        encoder_append_bool(encoder_p, src_p->value.c051);
        break;

    case uper_c_source_q_choice_c052_e:
        encoder_append_non_negative_binary_integer(encoder_p, 51, 9);
        encoder_append_bool(encoder_p, src_p->value.c052);
        break;

    case uper_c_source_q_choice_c053_e:
        encoder_append_non_negative_binary_integer(encoder_p, 52, 9);
        encoder_append_bool(encoder_p, src_p->value.c053);
        break;

    case uper_c_source_q_choice_c054_e:
        encoder_append_non_negative_binary_integer(encoder_p, 53, 9);
        encoder_append_bool(encoder_p, src_p->value.c054);
        break;

    case uper_c_source_q_choice_c055_e:
        encoder_append_non_negative_binary_integer(encoder_p, 54, 9);
        encoder_append_bool(encoder_p, src_p->value.c055);
        break;

    case uper_c_source_q_choice_c056_e:
        encoder_append_non_negative_binary_integer(encoder_p, 55, 9);
        encoder_append_bool(encoder_p, src_p->value.c056);
        break;

    case uper_c_source_q_choice_c057_e:
        encoder_append_non_negative_binary_integer(encoder_p, 56, 9);
        encoder_append_bool(encoder_p, src_p->value.c057);
        break;

    case uper_c_source_q_choice_c058_e:
        encoder_append_non_negative_binary_integer(encoder_p, 57, 9);
        encoder_append_bool(encoder_p, src_p->value.c058);
        break;

    case uper_c_source_q_choice_c059_e:
        encoder_append_non_negative_binary_integer(encoder_p, 58, 9);
        encoder_append_bool(encoder_p, src_p->value.c059);
        break;

    case uper_c_source_q_choice_c060_e:
        encoder_append_non_negative_binary_integer(encoder_p, 59, 9);
        encoder_append_bool(encoder_p, src_p->value.c060);
        break;

    case uper_c_source_q_choice_c061_e:
        encoder_append_non_negative_binary_integer(encoder_p, 60, 9);
        encoder_append_bool(encoder_p, src_p->value.c061);
        break;

    case uper_c_source_q_choice_c062_e:
        encoder_append_non_negative_binary_integer(encoder_p, 61, 9);
        encoder_append_bool(encoder_p, src_p->value.c062);
        break;

    case uper_c_source_q_choice_c063_e:
        encoder_append_non_negative_binary_integer(encoder_p, 62, 9);
        encoder_append_bool(encoder_p, src_p->value.c063);
        break;

    case uper_c_source_q_choice_c064_e:
        encoder_append_non_negative_binary_integer(encoder_p, 63, 9);
        encoder_append_bool(encoder_p, src_p->value.c064);
        break;

    case uper_c_source_q_choice_c065_e:
        encoder_append_non_negative_binary_integer(encoder_p, 64, 9);
        encoder_append_bool(encoder_p, src_p->value.c065);
        break;

    case uper_c_source_q_choice_c066_e:
        encoder_append_non_negative_binary_integer(encoder_p, 65, 9);
        encoder_append_bool(encoder_p, src_p->value.c066);
        break;

    case uper_c_source_q_choice_c067_e:
        encoder_append_non_negative_binary_integer(encoder_p, 66, 9);
        encoder_append_bool(encoder_p, src_p->value.c067);
        break;

    case uper_c_source_q_choice_c068_e:
        encoder_append_non_negative_binary_integer(encoder_p, 67, 9);
        encoder_append_bool(encoder_p, src_p->value.c068);
        break;

    case uper_c_source_q_choice_c069_e:
        encoder_append_non_negative_binary_integer(encoder_p, 68, 9);
        encoder_append_bool(encoder_p, src_p->value.c069);
        break;

    case uper_c_source_q_choice_c070_e:
        encoder_append_non_negative_binary_integer(encoder_p, 69, 9);
        encoder_append_bool(encoder_p, src_p->value.c070);
        break;

    case uper_c_source_q_choice_c071_e:
        encoder_append_non_negative_binary_integer(encoder_p, 70, 9);
        encoder_append_bool(encoder_p, src_p->value.c071);
        break;

    case uper_c_source_q_choice_c072_e:
        encoder_append_non_negative_binary_integer(encoder_p, 71, 9);
        encoder_append_bool(encoder_p, src_p->value.c072);
        break;

    case uper_c_source_q_choice_c073_e:
        encoder_append_non_negative_binary_integer(encoder_p, 72, 9);
        encoder_append_bool(encoder_p, src_p->value.c073);
        break;

    case uper_c_source_q_choice_c074_e:
        encoder_append_non_negative_binary_integer(encoder_p, 73, 9);
        encoder_append_bool(encoder_p, src_p->value.c074);
        break;

    case uper_c_source_q_choice_c075_e:
        encoder_append_non_negative_binary_integer(encoder_p, 74, 9);
        encoder_append_bool(encoder_p, src_p->value.c075);
        break;

    case uper_c_source_q_choice_c076_e:
        encoder_append_non_negative_binary_integer(encoder_p, 75, 9);
        encoder_append_bool(encoder_p, src_p->value.c076);
        break;

    case uper_c_source_q_choice_c077_e:
        encoder_append_non_negative_binary_integer(encoder_p, 76, 9);
        encoder_append_bool(encoder_p, src_p->value.c077);
        break;

    case uper_c_source_q_choice_c078_e:
        encoder_append_non_negative_binary_integer(encoder_p, 77, 9);
        encoder_append_bool(encoder_p, src_p->value.c078);
        break;

    case uper_c_source_q_choice_c079_e:
        encoder_append_non_negative_binary_integer(encoder_p, 78, 9);
        encoder_append_bool(encoder_p, src_p->value.c079);
        break;

    case uper_c_source_q_choice_c080_e:
        encoder_append_non_negative_binary_integer(encoder_p, 79, 9);
        encoder_append_bool(encoder_p, src_p->value.c080);
        break;

    case uper_c_source_q_choice_c081_e:
        encoder_append_non_negative_binary_integer(encoder_p, 80, 9);
        encoder_append_bool(encoder_p, src_p->value.c081);
        break;

    case uper_c_source_q_choice_c082_e:
        encoder_append_non_negative_binary_integer(encoder_p, 81, 9);
        encoder_append_bool(encoder_p, src_p->value.c082);
        break;

    case uper_c_source_q_choice_c083_e:
        encoder_append_non_negative_binary_integer(encoder_p, 82, 9);
        encoder_append_bool(encoder_p, src_p->value.c083);
        break;

    case uper_c_source_q_choice_c084_e:
        encoder_append_non_negative_binary_integer(encoder_p, 83, 9);
        encoder_append_bool(encoder_p, src_p->value.c084);
        break;

    case uper_c_source_q_choice_c085_e:
        encoder_append_non_negative_binary_integer(encoder_p, 84, 9);
        encoder_append_bool(encoder_p, src_p->value.c085);
        break;

    case uper_c_source_q_choice_c086_e:
        encoder_append_non_negative_binary_integer(encoder_p, 85, 9);
        encoder_append_bool(encoder_p, src_p->value.c086);
        break;

    case uper_c_source_q_choice_c087_e:
        encoder_append_non_negative_binary_integer(encoder_p, 86, 9);
        encoder_append_bool(encoder_p, src_p->value.c087);
        break;

    case uper_c_source_q_choice_c088_e:
        encoder_append_non_negative_binary_integer(encoder_p, 87, 9);
        encoder_append_bool(encoder_p, src_p->value.c088);
        break;

    case uper_c_source_q_choice_c089_e:
        encoder_append_non_negative_binary_integer(encoder_p, 88, 9);
        encoder_append_bool(encoder_p, src_p->value.c089);
        break;

    case uper_c_source_q_choice_c090_e:
        encoder_append_non_negative_binary_integer(encoder_p, 89, 9);
        encoder_append_bool(encoder_p, src_p->value.c090);
        break;

    case uper_c_source_q_choice_c091_e:
        encoder_append_non_negative_binary_integer(encoder_p, 90, 9);
        encoder_append_bool(encoder_p, src_p->value.c091);
        break;

    case uper_c_source_q_choice_c092_e:
        encoder_append_non_negative_binary_integer(encoder_p, 91, 9);
        encoder_append_bool(encoder_p, src_p->value.c092);
        break;

    case uper_c_source_q_choice_c093_e:
        encoder_append_non_negative_binary_integer(encoder_p, 92, 9);
        encoder_append_bool(encoder_p, src_p->value.c093);
        break;

    case uper_c_source_q_choice_c094_e:
        encoder_append_non_negative_binary_integer(encoder_p, 93, 9);
        encoder_append_bool(encoder_p, src_p->value.c094);
        break;

    case uper_c_source_q_choice_c095_e:
        encoder_append_non_negative_binary_integer(encoder_p, 94, 9);
        encoder_append_bool(encoder_p, src_p->value.c095);
        break;

    case uper_c_source_q_choice_c096_e:
        encoder_append_non_negative_binary_integer(encoder_p, 95, 9);
        encoder_append_bool(encoder_p, src_p->value.c096);
        break;

    case uper_c_source_q_choice_c097_e:
        encoder_append_non_negative_binary_integer(encoder_p, 96, 9);
        encoder_append_bool(encoder_p, src_p->value.c097);
        break;

    case uper_c_source_q_choice_c098_e:
        encoder_append_non_negative_binary_integer(encoder_p, 97, 9);
        encoder_append_bool(encoder_p, src_p->value.c098);
        break;

    case uper_c_source_q_choice_c099_e:
        encoder_append_non_negative_binary_integer(encoder_p, 98, 9);
        encoder_append_bool(encoder_p, src_p->value.c099);
        break;

    case uper_c_source_q_choice_c100_e:
        encoder_append_non_negative_binary_integer(encoder_p, 99, 9);
        encoder_append_bool(encoder_p, src_p->value.c100);
        break;

    case uper_c_source_q_choice_c101_e:
        encoder_append_non_negative_binary_integer(encoder_p, 100, 9);
        encoder_append_bool(encoder_p, src_p->value.c101);
        break;

    case uper_c_source_q_choice_c102_e:
        encoder_append_non_negative_binary_integer(encoder_p, 101, 9);
        encoder_append_bool(encoder_p, src_p->value.c102);
        break;

    case uper_c_source_q_choice_c103_e:
        encoder_append_non_negative_binary_integer(encoder_p, 102, 9);
        encoder_append_bool(encoder_p, src_p->value.c103);
        break;

    case uper_c_source_q_choice_c104_e:
        encoder_append_non_negative_binary_integer(encoder_p, 103, 9);
        encoder_append_bool(encoder_p, src_p->value.c104);
        break;

    case uper_c_source_q_choice_c105_e:
        encoder_append_non_negative_binary_integer(encoder_p, 104, 9);
        encoder_append_bool(encoder_p, src_p->value.c105);
        break;

    case uper_c_source_q_choice_c106_e:
        encoder_append_non_negative_binary_integer(encoder_p, 105, 9);
        encoder_append_bool(encoder_p, src_p->value.c106);
        break;

    case uper_c_source_q_choice_c107_e:
        encoder_append_non_negative_binary_integer(encoder_p, 106, 9);
        encoder_append_bool(encoder_p, src_p->value.c107);
        break;

    case uper_c_source_q_choice_c108_e:
        encoder_append_non_negative_binary_integer(encoder_p, 107, 9);
        encoder_append_bool(encoder_p, src_p->value.c108);
        break;

    case uper_c_source_q_choice_c109_e:
        encoder_append_non_negative_binary_integer(encoder_p, 108, 9);
        encoder_append_bool(encoder_p, src_p->value.c109);
        break;

    case uper_c_source_q_choice_c110_e:
        encoder_append_non_negative_binary_integer(encoder_p, 109, 9);
        encoder_append_bool(encoder_p, src_p->value.c110);
        break;

    case uper_c_source_q_choice_c111_e:
        encoder_append_non_negative_binary_integer(encoder_p, 110, 9);
        encoder_append_bool(encoder_p, src_p->value.c111);
        break;

    case uper_c_source_q_choice_c112_e:
        encoder_append_non_negative_binary_integer(encoder_p, 111, 9);
        encoder_append_bool(encoder_p, src_p->value.c112);
        break;

    case uper_c_source_q_choice_c113_e:
        encoder_append_non_negative_binary_integer(encoder_p, 112, 9);
        encoder_append_bool(encoder_p, src_p->value.c113);
        break;

    case uper_c_source_q_choice_c114_e:
        encoder_append_non_negative_binary_integer(encoder_p, 113, 9);
        encoder_append_bool(encoder_p, src_p->value.c114);
        break;

    case uper_c_source_q_choice_c115_e:
        encoder_append_non_negative_binary_integer(encoder_p, 114, 9);
        encoder_append_bool(encoder_p, src_p->value.c115);
        break;

    case uper_c_source_q_choice_c116_e:
        encoder_append_non_negative_binary_integer(encoder_p, 115, 9);
        encoder_append_bool(encoder_p, src_p->value.c116);
        break;

    case uper_c_source_q_choice_c117_e:
        encoder_append_non_negative_binary_integer(encoder_p, 116, 9);
        encoder_append_bool(encoder_p, src_p->value.c117);
        break;

    case uper_c_source_q_choice_c118_e:
        encoder_append_non_negative_binary_integer(encoder_p, 117, 9);
        encoder_append_bool(encoder_p, src_p->value.c118);
        break;

    case uper_c_source_q_choice_c119_e:
        encoder_append_non_negative_binary_integer(encoder_p, 118, 9);
        encoder_append_bool(encoder_p, src_p->value.c119);
        break;

    case uper_c_source_q_choice_c120_e:
        encoder_append_non_negative_binary_integer(encoder_p, 119, 9);
        encoder_append_bool(encoder_p, src_p->value.c120);
        break;

    case uper_c_source_q_choice_c121_e:
        encoder_append_non_negative_binary_integer(encoder_p, 120, 9);
        encoder_append_bool(encoder_p, src_p->value.c121);
        break;

    case uper_c_source_q_choice_c122_e:
        encoder_append_non_negative_binary_integer(encoder_p, 121, 9);
        encoder_append_bool(encoder_p, src_p->value.c122);
        break;

    case uper_c_source_q_choice_c123_e:
        encoder_append_non_negative_binary_integer(encoder_p, 122, 9);
        encoder_append_bool(encoder_p, src_p->value.c123);
        break;

    case uper_c_source_q_choice_c124_e:
        encoder_append_non_negative_binary_integer(encoder_p, 123, 9);
        encoder_append_bool(encoder_p, src_p->value.c124);
        break;

    case uper_c_source_q_choice_c125_e:
        encoder_append_non_negative_binary_integer(encoder_p, 124, 9);
        encoder_append_bool(encoder_p, src_p->value.c125);
        break;

    case uper_c_source_q_choice_c126_e:
        encoder_append_non_negative_binary_integer(encoder_p, 125, 9);
        encoder_append_bool(encoder_p, src_p->value.c126);
        break;

    case uper_c_source_q_choice_c127_e:
        encoder_append_non_negative_binary_integer(encoder_p, 126, 9);
        encoder_append_bool(encoder_p, src_p->value.c127);
        break;

    case uper_c_source_q_choice_c128_e:
        encoder_append_non_negative_binary_integer(encoder_p, 127, 9);
        encoder_append_bool(encoder_p, src_p->value.c128);
        break;

    case uper_c_source_q_choice_c129_e:
        encoder_append_non_negative_binary_integer(encoder_p, 128, 9);
        encoder_append_bool(encoder_p, src_p->value.c129);
        break;

    case uper_c_source_q_choice_c130_e:
        encoder_append_non_negative_binary_integer(encoder_p, 129, 9);
        encoder_append_bool(encoder_p, src_p->value.c130);
        break;

    case uper_c_source_q_choice_c131_e:
        encoder_append_non_negative_binary_integer(encoder_p, 130, 9);
        encoder_append_bool(encoder_p, src_p->value.c131);
        break;

    case uper_c_source_q_choice_c132_e:
        encoder_append_non_negative_binary_integer(encoder_p, 131, 9);
        encoder_append_bool(encoder_p, src_p->value.c132);
        break;

    case uper_c_source_q_choice_c133_e:
        encoder_append_non_negative_binary_integer(encoder_p, 132, 9);
        encoder_append_bool(encoder_p, src_p->value.c133);
        break;

    case uper_c_source_q_choice_c134_e:
        encoder_append_non_negative_binary_integer(encoder_p, 133, 9);
        encoder_append_bool(encoder_p, src_p->value.c134);
        break;

    case uper_c_source_q_choice_c135_e:
        encoder_append_non_negative_binary_integer(encoder_p, 134, 9);
        encoder_append_bool(encoder_p, src_p->value.c135);
        break;

    case uper_c_source_q_choice_c136_e:
        encoder_append_non_negative_binary_integer(encoder_p, 135, 9);
        encoder_append_bool(encoder_p, src_p->value.c136);
        break;

    case uper_c_source_q_choice_c137_e:
        encoder_append_non_negative_binary_integer(encoder_p, 136, 9);
        encoder_append_bool(encoder_p, src_p->value.c137);
        break;

    case uper_c_source_q_choice_c138_e:
        encoder_append_non_negative_binary_integer(encoder_p, 137, 9);
        encoder_append_bool(encoder_p, src_p->value.c138);
        break;

    case uper_c_source_q_choice_c139_e:
        encoder_append_non_negative_binary_integer(encoder_p, 138, 9);
        encoder_append_bool(encoder_p, src_p->value.c139);
        break;

    case uper_c_source_q_choice_c140_e:
        encoder_append_non_negative_binary_integer(encoder_p, 139, 9);
        encoder_append_bool(encoder_p, src_p->value.c140);
        break;

    case uper_c_source_q_choice_c141_e:
        encoder_append_non_negative_binary_integer(encoder_p, 140, 9);
        encoder_append_bool(encoder_p, src_p->value.c141);
        break;

    case uper_c_source_q_choice_c142_e:
        encoder_append_non_negative_binary_integer(encoder_p, 141, 9);
        encoder_append_bool(encoder_p, src_p->value.c142);
        break;

    case uper_c_source_q_choice_c143_e:
        encoder_append_non_negative_binary_integer(encoder_p, 142, 9);
        encoder_append_bool(encoder_p, src_p->value.c143);
        break;

    case uper_c_source_q_choice_c144_e:
        encoder_append_non_negative_binary_integer(encoder_p, 143, 9);
        encoder_append_bool(encoder_p, src_p->value.c144);
        break;

    case uper_c_source_q_choice_c145_e:
        encoder_append_non_negative_binary_integer(encoder_p, 144, 9);
        encoder_append_bool(encoder_p, src_p->value.c145);
        break;

    case uper_c_source_q_choice_c146_e:
        encoder_append_non_negative_binary_integer(encoder_p, 145, 9);
        encoder_append_bool(encoder_p, src_p->value.c146);
        break;

    case uper_c_source_q_choice_c147_e:
        encoder_append_non_negative_binary_integer(encoder_p, 146, 9);
        encoder_append_bool(encoder_p, src_p->value.c147);
        break;

    case uper_c_source_q_choice_c148_e:
        encoder_append_non_negative_binary_integer(encoder_p, 147, 9);
        encoder_append_bool(encoder_p, src_p->value.c148);
        break;

    case uper_c_source_q_choice_c149_e:
        encoder_append_non_negative_binary_integer(encoder_p, 148, 9);
        encoder_append_bool(encoder_p, src_p->value.c149);
        break;

    case uper_c_source_q_choice_c150_e:
        encoder_append_non_negative_binary_integer(encoder_p, 149, 9);
        encoder_append_bool(encoder_p, src_p->value.c150);
        break;

    case uper_c_source_q_choice_c151_e:
        encoder_append_non_negative_binary_integer(encoder_p, 150, 9);
        encoder_append_bool(encoder_p, src_p->value.c151);
        break;

    case uper_c_source_q_choice_c152_e:
        encoder_append_non_negative_binary_integer(encoder_p, 151, 9);
        encoder_append_bool(encoder_p, src_p->value.c152);
        break;

    case uper_c_source_q_choice_c153_e:
        encoder_append_non_negative_binary_integer(encoder_p, 152, 9);
        encoder_append_bool(encoder_p, src_p->value.c153);
        break;

    case uper_c_source_q_choice_c154_e:
        encoder_append_non_negative_binary_integer(encoder_p, 153, 9);
        encoder_append_bool(encoder_p, src_p->value.c154);
        break;

    case uper_c_source_q_choice_c155_e:
        encoder_append_non_negative_binary_integer(encoder_p, 154, 9);
        encoder_append_bool(encoder_p, src_p->value.c155);
        break;

    case uper_c_source_q_choice_c156_e:
        encoder_append_non_negative_binary_integer(encoder_p, 155, 9);
        encoder_append_bool(encoder_p, src_p->value.c156);
        break;

    case uper_c_source_q_choice_c157_e:
        encoder_append_non_negative_binary_integer(encoder_p, 156, 9);
        encoder_append_bool(encoder_p, src_p->value.c157);
        break;

    case uper_c_source_q_choice_c158_e:
        encoder_append_non_negative_binary_integer(encoder_p, 157, 9);
        encoder_append_bool(encoder_p, src_p->value.c158);
        break;

    case uper_c_source_q_choice_c159_e:
        encoder_append_non_negative_binary_integer(encoder_p, 158, 9);
        encoder_append_bool(encoder_p, src_p->value.c159);
        break;

    case uper_c_source_q_choice_c160_e:
        encoder_append_non_negative_binary_integer(encoder_p, 159, 9);
        encoder_append_bool(encoder_p, src_p->value.c160);
        break;

    case uper_c_source_q_choice_c161_e:
        encoder_append_non_negative_binary_integer(encoder_p, 160, 9);
        encoder_append_bool(encoder_p, src_p->value.c161);
        break;

    case uper_c_source_q_choice_c162_e:
        encoder_append_non_negative_binary_integer(encoder_p, 161, 9);
        encoder_append_bool(encoder_p, src_p->value.c162);
        break;

    case uper_c_source_q_choice_c163_e:
        encoder_append_non_negative_binary_integer(encoder_p, 162, 9);
        encoder_append_bool(encoder_p, src_p->value.c163);
        break;

    case uper_c_source_q_choice_c164_e:
        encoder_append_non_negative_binary_integer(encoder_p, 163, 9);
        encoder_append_bool(encoder_p, src_p->value.c164);
        break;

    case uper_c_source_q_choice_c165_e:
        encoder_append_non_negative_binary_integer(encoder_p, 164, 9);
        encoder_append_bool(encoder_p, src_p->value.c165);
        break;

    case uper_c_source_q_choice_c166_e:
        encoder_append_non_negative_binary_integer(encoder_p, 165, 9);
        encoder_append_bool(encoder_p, src_p->value.c166);
        break;

    case uper_c_source_q_choice_c167_e:
        encoder_append_non_negative_binary_integer(encoder_p, 166, 9);
        encoder_append_bool(encoder_p, src_p->value.c167);
        break;

    case uper_c_source_q_choice_c168_e:
        encoder_append_non_negative_binary_integer(encoder_p, 167, 9);
        encoder_append_bool(encoder_p, src_p->value.c168);
        break;

    case uper_c_source_q_choice_c169_e:
        encoder_append_non_negative_binary_integer(encoder_p, 168, 9);
        encoder_append_bool(encoder_p, src_p->value.c169);
        break;

    case uper_c_source_q_choice_c170_e:
        encoder_append_non_negative_binary_integer(encoder_p, 169, 9);
        encoder_append_bool(encoder_p, src_p->value.c170);
        break;

    case uper_c_source_q_choice_c171_e:
        encoder_append_non_negative_binary_integer(encoder_p, 170, 9);
        encoder_append_bool(encoder_p, src_p->value.c171);
        break;

    case uper_c_source_q_choice_c172_e:
        encoder_append_non_negative_binary_integer(encoder_p, 171, 9);
        encoder_append_bool(encoder_p, src_p->value.c172);
        break;

    case uper_c_source_q_choice_c173_e:
        encoder_append_non_negative_binary_integer(encoder_p, 172, 9);
        encoder_append_bool(encoder_p, src_p->value.c173);
        break;

    case uper_c_source_q_choice_c174_e:
        encoder_append_non_negative_binary_integer(encoder_p, 173, 9);
        encoder_append_bool(encoder_p, src_p->value.c174);
        break;

    case uper_c_source_q_choice_c175_e:
        encoder_append_non_negative_binary_integer(encoder_p, 174, 9);
        encoder_append_bool(encoder_p, src_p->value.c175);
        break;

    case uper_c_source_q_choice_c176_e:
        encoder_append_non_negative_binary_integer(encoder_p, 175, 9);
        encoder_append_bool(encoder_p, src_p->value.c176);
        break;

    case uper_c_source_q_choice_c177_e:
        encoder_append_non_negative_binary_integer(encoder_p, 176, 9);
        encoder_append_bool(encoder_p, src_p->value.c177);
        break;

    case uper_c_source_q_choice_c178_e:
        encoder_append_non_negative_binary_integer(encoder_p, 177, 9);
        encoder_append_bool(encoder_p, src_p->value.c178);
        break;

    case uper_c_source_q_choice_c179_e:
        encoder_append_non_negative_binary_integer(encoder_p, 178, 9);
        encoder_append_bool(encoder_p, src_p->value.c179);
        break;

    case uper_c_source_q_choice_c180_e:
        encoder_append_non_negative_binary_integer(encoder_p, 179, 9);
        encoder_append_bool(encoder_p, src_p->value.c180);
        break;

    case uper_c_source_q_choice_c181_e:
        encoder_append_non_negative_binary_integer(encoder_p, 180, 9);
        encoder_append_bool(encoder_p, src_p->value.c181);
        break;

    case uper_c_source_q_choice_c182_e:
        encoder_append_non_negative_binary_integer(encoder_p, 181, 9);
        encoder_append_bool(encoder_p, src_p->value.c182);
        break;

    case uper_c_source_q_choice_c183_e:
        encoder_append_non_negative_binary_integer(encoder_p, 182, 9);
        encoder_append_bool(encoder_p, src_p->value.c183);
        break;

    case uper_c_source_q_choice_c184_e:
        encoder_append_non_negative_binary_integer(encoder_p, 183, 9);
        encoder_append_bool(encoder_p, src_p->value.c184);
        break;

    case uper_c_source_q_choice_c185_e:
        encoder_append_non_negative_binary_integer(encoder_p, 184, 9);
        encoder_append_bool(encoder_p, src_p->value.c185);
        break;

    case uper_c_source_q_choice_c186_e:
        encoder_append_non_negative_binary_integer(encoder_p, 185, 9);
        encoder_append_bool(encoder_p, src_p->value.c186);
        break;

    case uper_c_source_q_choice_c187_e:
        encoder_append_non_negative_binary_integer(encoder_p, 186, 9);
        encoder_append_bool(encoder_p, src_p->value.c187);
        break;

    case uper_c_source_q_choice_c188_e:
        encoder_append_non_negative_binary_integer(encoder_p, 187, 9);
        encoder_append_bool(encoder_p, src_p->value.c188);
        break;

    case uper_c_source_q_choice_c189_e:
        encoder_append_non_negative_binary_integer(encoder_p, 188, 9);
        encoder_append_bool(encoder_p, src_p->value.c189);
        break;

    case uper_c_source_q_choice_c190_e:
        encoder_append_non_negative_binary_integer(encoder_p, 189, 9);
        encoder_append_bool(encoder_p, src_p->value.c190);
        break;

    case uper_c_source_q_choice_c191_e:
        encoder_append_non_negative_binary_integer(encoder_p, 190, 9);
        encoder_append_bool(encoder_p, src_p->value.c191);
        break;

    case uper_c_source_q_choice_c192_e:
        encoder_append_non_negative_binary_integer(encoder_p, 191, 9);
        encoder_append_bool(encoder_p, src_p->value.c192);
        break;

    case uper_c_source_q_choice_c193_e:
        encoder_append_non_negative_binary_integer(encoder_p, 192, 9);
        encoder_append_bool(encoder_p, src_p->value.c193);
        break;

    case uper_c_source_q_choice_c194_e:
        encoder_append_non_negative_binary_integer(encoder_p, 193, 9);
        encoder_append_bool(encoder_p, src_p->value.c194);
        break;

    case uper_c_source_q_choice_c195_e:
        encoder_append_non_negative_binary_integer(encoder_p, 194, 9);
        encoder_append_bool(encoder_p, src_p->value.c195);
        break;

    case uper_c_source_q_choice_c196_e:
        encoder_append_non_negative_binary_integer(encoder_p, 195, 9);
        encoder_append_bool(encoder_p, src_p->value.c196);
        break;

    case uper_c_source_q_choice_c197_e:
        encoder_append_non_negative_binary_integer(encoder_p, 196, 9);
        encoder_append_bool(encoder_p, src_p->value.c197);
        break;

    case uper_c_source_q_choice_c198_e:
        encoder_append_non_negative_binary_integer(encoder_p, 197, 9);
        encoder_append_bool(encoder_p, src_p->value.c198);
        break;

    case uper_c_source_q_choice_c199_e:
        encoder_append_non_negative_binary_integer(encoder_p, 198, 9);
        encoder_append_bool(encoder_p, src_p->value.c199);
        break;

    case uper_c_source_q_choice_c200_e:
        encoder_append_non_negative_binary_integer(encoder_p, 199, 9);
        encoder_append_bool(encoder_p, src_p->value.c200);
        break;

    case uper_c_source_q_choice_c201_e:
        encoder_append_non_negative_binary_integer(encoder_p, 200, 9);
        encoder_append_bool(encoder_p, src_p->value.c201);
        break;

    case uper_c_source_q_choice_c202_e:
        encoder_append_non_negative_binary_integer(encoder_p, 201, 9);
        encoder_append_bool(encoder_p, src_p->value.c202);
        break;

    case uper_c_source_q_choice_c203_e:
        encoder_append_non_negative_binary_integer(encoder_p, 202, 9);
        encoder_append_bool(encoder_p, src_p->value.c203);
        break;

    case uper_c_source_q_choice_c204_e:
        encoder_append_non_negative_binary_integer(encoder_p, 203, 9);
        encoder_append_bool(encoder_p, src_p->value.c204);
        break;

    case uper_c_source_q_choice_c205_e:
        encoder_append_non_negative_binary_integer(encoder_p, 204, 9);
        encoder_append_bool(encoder_p, src_p->value.c205);
        break;

    case uper_c_source_q_choice_c206_e:
        encoder_append_non_negative_binary_integer(encoder_p, 205, 9);
        encoder_append_bool(encoder_p, src_p->value.c206);
        break;

    case uper_c_source_q_choice_c207_e:
        encoder_append_non_negative_binary_integer(encoder_p, 206, 9);
        encoder_append_bool(encoder_p, src_p->value.c207);
        break;

    case uper_c_source_q_choice_c208_e:
        encoder_append_non_negative_binary_integer(encoder_p, 207, 9);
        encoder_append_bool(encoder_p, src_p->value.c208);
        break;

    case uper_c_source_q_choice_c209_e:
        encoder_append_non_negative_binary_integer(encoder_p, 208, 9);
        encoder_append_bool(encoder_p, src_p->value.c209);
        break;

    case uper_c_source_q_choice_c210_e:
        encoder_append_non_negative_binary_integer(encoder_p, 209, 9);
        encoder_append_bool(encoder_p, src_p->value.c210);
        break;

    case uper_c_source_q_choice_c211_e:
        encoder_append_non_negative_binary_integer(encoder_p, 210, 9);
        encoder_append_bool(encoder_p, src_p->value.c211);
        break;

    case uper_c_source_q_choice_c212_e:
        encoder_append_non_negative_binary_integer(encoder_p, 211, 9);
        encoder_append_bool(encoder_p, src_p->value.c212);
        break;

    case uper_c_source_q_choice_c213_e:
        encoder_append_non_negative_binary_integer(encoder_p, 212, 9);
        encoder_append_bool(encoder_p, src_p->value.c213);
        break;

    case uper_c_source_q_choice_c214_e:
        encoder_append_non_negative_binary_integer(encoder_p, 213, 9);
        encoder_append_bool(encoder_p, src_p->value.c214);
        break;

    case uper_c_source_q_choice_c215_e:
        encoder_append_non_negative_binary_integer(encoder_p, 214, 9);
        encoder_append_bool(encoder_p, src_p->value.c215);
        break;

    case uper_c_source_q_choice_c216_e:
        encoder_append_non_negative_binary_integer(encoder_p, 215, 9);
        encoder_append_bool(encoder_p, src_p->value.c216);
        break;

    case uper_c_source_q_choice_c217_e:
        encoder_append_non_negative_binary_integer(encoder_p, 216, 9);
        encoder_append_bool(encoder_p, src_p->value.c217);
        break;

    case uper_c_source_q_choice_c218_e:
        encoder_append_non_negative_binary_integer(encoder_p, 217, 9);
        encoder_append_bool(encoder_p, src_p->value.c218);
        break;

    case uper_c_source_q_choice_c219_e:
        encoder_append_non_negative_binary_integer(encoder_p, 218, 9);
        encoder_append_bool(encoder_p, src_p->value.c219);
        break;

    case uper_c_source_q_choice_c220_e:
        encoder_append_non_negative_binary_integer(encoder_p, 219, 9);
        encoder_append_bool(encoder_p, src_p->value.c220);
        break;

    case uper_c_source_q_choice_c221_e:
        encoder_append_non_negative_binary_integer(encoder_p, 220, 9);
        encoder_append_bool(encoder_p, src_p->value.c221);
        break;

    case uper_c_source_q_choice_c222_e:
        encoder_append_non_negative_binary_integer(encoder_p, 221, 9);
        encoder_append_bool(encoder_p, src_p->value.c222);
        break;

    case uper_c_source_q_choice_c223_e:
        encoder_append_non_negative_binary_integer(encoder_p, 222, 9);
        encoder_append_bool(encoder_p, src_p->value.c223);
        break;

    case uper_c_source_q_choice_c224_e:
        encoder_append_non_negative_binary_integer(encoder_p, 223, 9);
        encoder_append_bool(encoder_p, src_p->value.c224);
        break;

    case uper_c_source_q_choice_c225_e:
        encoder_append_non_negative_binary_integer(encoder_p, 224, 9);
        encoder_append_bool(encoder_p, src_p->value.c225);
        break;

    case uper_c_source_q_choice_c226_e:
        encoder_append_non_negative_binary_integer(encoder_p, 225, 9);
        encoder_append_bool(encoder_p, src_p->value.c226);
        break;

    case uper_c_source_q_choice_c227_e:
        encoder_append_non_negative_binary_integer(encoder_p, 226, 9);
        encoder_append_bool(encoder_p, src_p->value.c227);
        break;

    case uper_c_source_q_choice_c228_e:
        encoder_append_non_negative_binary_integer(encoder_p, 227, 9);
        encoder_append_bool(encoder_p, src_p->value.c228);
        break;

    case uper_c_source_q_choice_c229_e:
        encoder_append_non_negative_binary_integer(encoder_p, 228, 9);
        encoder_append_bool(encoder_p, src_p->value.c229);
        break;

    case uper_c_source_q_choice_c230_e:
        encoder_append_non_negative_binary_integer(encoder_p, 229, 9);
        encoder_append_bool(encoder_p, src_p->value.c230);
        break;

    case uper_c_source_q_choice_c231_e:
        encoder_append_non_negative_binary_integer(encoder_p, 230, 9);
        encoder_append_bool(encoder_p, src_p->value.c231);
        break;

    case uper_c_source_q_choice_c232_e:
        encoder_append_non_negative_binary_integer(encoder_p, 231, 9);
        encoder_append_bool(encoder_p, src_p->value.c232);
        break;

    case uper_c_source_q_choice_c233_e:
        encoder_append_non_negative_binary_integer(encoder_p, 232, 9);
        encoder_append_bool(encoder_p, src_p->value.c233);
        break;

    case uper_c_source_q_choice_c234_e:
        encoder_append_non_negative_binary_integer(encoder_p, 233, 9);
        encoder_append_bool(encoder_p, src_p->value.c234);
        break;

    case uper_c_source_q_choice_c235_e:
        encoder_append_non_negative_binary_integer(encoder_p, 234, 9);
        encoder_append_bool(encoder_p, src_p->value.c235);
        break;

    case uper_c_source_q_choice_c236_e:
        encoder_append_non_negative_binary_integer(encoder_p, 235, 9);
        encoder_append_bool(encoder_p, src_p->value.c236);
        break;

    case uper_c_source_q_choice_c237_e:
        encoder_append_non_negative_binary_integer(encoder_p, 236, 9);
        encoder_append_bool(encoder_p, src_p->value.c237);
        break;

    case uper_c_source_q_choice_c238_e:
        encoder_append_non_negative_binary_integer(encoder_p, 237, 9);
        encoder_append_bool(encoder_p, src_p->value.c238);
        break;

    case uper_c_source_q_choice_c239_e:
        encoder_append_non_negative_binary_integer(encoder_p, 238, 9);
        encoder_append_bool(encoder_p, src_p->value.c239);
        break;

    case uper_c_source_q_choice_c240_e:
        encoder_append_non_negative_binary_integer(encoder_p, 239, 9);
        encoder_append_bool(encoder_p, src_p->value.c240);
        break;

    case uper_c_source_q_choice_c241_e:
        encoder_append_non_negative_binary_integer(encoder_p, 240, 9);
        encoder_append_bool(encoder_p, src_p->value.c241);
        break;

    case uper_c_source_q_choice_c242_e:
        encoder_append_non_negative_binary_integer(encoder_p, 241, 9);
        encoder_append_bool(encoder_p, src_p->value.c242);
        break;

    case uper_c_source_q_choice_c243_e:
        encoder_append_non_negative_binary_integer(encoder_p, 242, 9);
        encoder_append_bool(encoder_p, src_p->value.c243);
        break;

    case uper_c_source_q_choice_c244_e:
        encoder_append_non_negative_binary_integer(encoder_p, 243, 9);
        encoder_append_bool(encoder_p, src_p->value.c244);
        break;

    case uper_c_source_q_choice_c245_e:
        encoder_append_non_negative_binary_integer(encoder_p, 244, 9);
        encoder_append_bool(encoder_p, src_p->value.c245);
        break;

    case uper_c_source_q_choice_c246_e:
        encoder_append_non_negative_binary_integer(encoder_p, 245, 9);
        encoder_append_bool(encoder_p, src_p->value.c246);
        break;

    case uper_c_source_q_choice_c247_e:
        encoder_append_non_negative_binary_integer(encoder_p, 246, 9);
        encoder_append_bool(encoder_p, src_p->value.c247);
        break;

    case uper_c_source_q_choice_c248_e:
        encoder_append_non_negative_binary_integer(encoder_p, 247, 9);
        encoder_append_bool(encoder_p, src_p->value.c248);
        break;

    case uper_c_source_q_choice_c249_e:
        encoder_append_non_negative_binary_integer(encoder_p, 248, 9);
        encoder_append_bool(encoder_p, src_p->value.c249);
        break;

    case uper_c_source_q_choice_c250_e:
        encoder_append_non_negative_binary_integer(encoder_p, 249, 9);
        encoder_append_bool(encoder_p, src_p->value.c250);
        break;

    case uper_c_source_q_choice_c251_e:
        encoder_append_non_negative_binary_integer(encoder_p, 250, 9);
        encoder_append_bool(encoder_p, src_p->value.c251);
        break;

    case uper_c_source_q_choice_c252_e:
        encoder_append_non_negative_binary_integer(encoder_p, 251, 9);
        encoder_append_bool(encoder_p, src_p->value.c252);
        break;

    case uper_c_source_q_choice_c253_e:
        encoder_append_non_negative_binary_integer(encoder_p, 252, 9);
        encoder_append_bool(encoder_p, src_p->value.c253);
        break;

    case uper_c_source_q_choice_c254_e:
        encoder_append_non_negative_binary_integer(encoder_p, 253, 9);
        encoder_append_bool(encoder_p, src_p->value.c254);
        break;

    case uper_c_source_q_choice_c255_e:
        encoder_append_non_negative_binary_integer(encoder_p, 254, 9);
        encoder_append_bool(encoder_p, src_p->value.c255);
        break;

    case uper_c_source_q_choice_c256_e:
        encoder_append_non_negative_binary_integer(encoder_p, 255, 9);
        encoder_append_bool(encoder_p, src_p->value.c256);
        break;

    case uper_c_source_q_choice_c257_e:
        encoder_append_non_negative_binary_integer(encoder_p, 256, 9);
        encoder_append_bool(encoder_p, src_p->value.c257);
        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }
}

static void uper_c_source_q_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_q_t *dst_p)
{
    uint16_t choice;

    choice = (uint16_t)decoder_read_non_negative_binary_integer(decoder_p, 9);

    switch (choice) {

    case 0:
        dst_p->choice = uper_c_source_q_choice_c001_e;
        dst_p->value.c001 = decoder_read_bool(decoder_p);
        break;

    case 1:
        dst_p->choice = uper_c_source_q_choice_c002_e;
        dst_p->value.c002 = decoder_read_bool(decoder_p);
        break;

    case 2:
        dst_p->choice = uper_c_source_q_choice_c003_e;
        dst_p->value.c003 = decoder_read_bool(decoder_p);
        break;

    case 3:
        dst_p->choice = uper_c_source_q_choice_c004_e;
        dst_p->value.c004 = decoder_read_bool(decoder_p);
        break;

    case 4:
        dst_p->choice = uper_c_source_q_choice_c005_e;
        dst_p->value.c005 = decoder_read_bool(decoder_p);
        break;

    case 5:
        dst_p->choice = uper_c_source_q_choice_c006_e;
        dst_p->value.c006 = decoder_read_bool(decoder_p);
        break;

    case 6:
        dst_p->choice = uper_c_source_q_choice_c007_e;
        dst_p->value.c007 = decoder_read_bool(decoder_p);
        break;

    case 7:
        dst_p->choice = uper_c_source_q_choice_c008_e;
        dst_p->value.c008 = decoder_read_bool(decoder_p);
        break;

    case 8:
        dst_p->choice = uper_c_source_q_choice_c009_e;
        dst_p->value.c009 = decoder_read_bool(decoder_p);
        break;

    case 9:
        dst_p->choice = uper_c_source_q_choice_c010_e;
        dst_p->value.c010 = decoder_read_bool(decoder_p);
        break;

    case 10:
        dst_p->choice = uper_c_source_q_choice_c011_e;
        dst_p->value.c011 = decoder_read_bool(decoder_p);
        break;

    case 11:
        dst_p->choice = uper_c_source_q_choice_c012_e;
        dst_p->value.c012 = decoder_read_bool(decoder_p);
        break;

    case 12:
        dst_p->choice = uper_c_source_q_choice_c013_e;
        dst_p->value.c013 = decoder_read_bool(decoder_p);
        break;

    case 13:
        dst_p->choice = uper_c_source_q_choice_c014_e;
        dst_p->value.c014 = decoder_read_bool(decoder_p);
        break;

    case 14:
        dst_p->choice = uper_c_source_q_choice_c015_e;
        dst_p->value.c015 = decoder_read_bool(decoder_p);
        break;

    case 15:
        dst_p->choice = uper_c_source_q_choice_c016_e;
        dst_p->value.c016 = decoder_read_bool(decoder_p);
        break;

    case 16:
        dst_p->choice = uper_c_source_q_choice_c017_e;
        dst_p->value.c017 = decoder_read_bool(decoder_p);
        break;

    case 17:
        dst_p->choice = uper_c_source_q_choice_c018_e;
        dst_p->value.c018 = decoder_read_bool(decoder_p);
        break;

    case 18:
        dst_p->choice = uper_c_source_q_choice_c019_e;
        dst_p->value.c019 = decoder_read_bool(decoder_p);
        break;

    case 19:
        dst_p->choice = uper_c_source_q_choice_c020_e;
        dst_p->value.c020 = decoder_read_bool(decoder_p);
        break;

    case 20:
        dst_p->choice = uper_c_source_q_choice_c021_e;
        dst_p->value.c021 = decoder_read_bool(decoder_p);
        break;

    case 21:
        dst_p->choice = uper_c_source_q_choice_c022_e;
        dst_p->value.c022 = decoder_read_bool(decoder_p);
        break;

    case 22:
        dst_p->choice = uper_c_source_q_choice_c023_e;
        dst_p->value.c023 = decoder_read_bool(decoder_p);
        break;

    case 23:
        dst_p->choice = uper_c_source_q_choice_c024_e;
        dst_p->value.c024 = decoder_read_bool(decoder_p);
        break;

    case 24:
        dst_p->choice = uper_c_source_q_choice_c025_e;
        dst_p->value.c025 = decoder_read_bool(decoder_p);
        break;

    case 25:
        dst_p->choice = uper_c_source_q_choice_c026_e;
        dst_p->value.c026 = decoder_read_bool(decoder_p);
        break;

    case 26:
        dst_p->choice = uper_c_source_q_choice_c027_e;
        dst_p->value.c027 = decoder_read_bool(decoder_p);
        break;

    case 27:
        dst_p->choice = uper_c_source_q_choice_c028_e;
        dst_p->value.c028 = decoder_read_bool(decoder_p);
        break;

    case 28:
        dst_p->choice = uper_c_source_q_choice_c029_e;
        dst_p->value.c029 = decoder_read_bool(decoder_p);
        break;

    case 29:
        dst_p->choice = uper_c_source_q_choice_c030_e;
        dst_p->value.c030 = decoder_read_bool(decoder_p);
        break;

    case 30:
        dst_p->choice = uper_c_source_q_choice_c031_e;
        dst_p->value.c031 = decoder_read_bool(decoder_p);
        break;

    case 31:
        dst_p->choice = uper_c_source_q_choice_c032_e;
        dst_p->value.c032 = decoder_read_bool(decoder_p);
        break;

    case 32:
        dst_p->choice = uper_c_source_q_choice_c033_e;
        dst_p->value.c033 = decoder_read_bool(decoder_p);
        break;

    case 33:
        dst_p->choice = uper_c_source_q_choice_c034_e;
        dst_p->value.c034 = decoder_read_bool(decoder_p);
        break;

    case 34:
        dst_p->choice = uper_c_source_q_choice_c035_e;
        dst_p->value.c035 = decoder_read_bool(decoder_p);
        break;

    case 35:
        dst_p->choice = uper_c_source_q_choice_c036_e;
        dst_p->value.c036 = decoder_read_bool(decoder_p);
        break;

    case 36:
        dst_p->choice = uper_c_source_q_choice_c037_e;
        dst_p->value.c037 = decoder_read_bool(decoder_p);
        break;

    case 37:
        dst_p->choice = uper_c_source_q_choice_c038_e;
        dst_p->value.c038 = decoder_read_bool(decoder_p);
        break;

    case 38:
        dst_p->choice = uper_c_source_q_choice_c039_e;
        dst_p->value.c039 = decoder_read_bool(decoder_p);
        break;

    case 39:
        dst_p->choice = uper_c_source_q_choice_c040_e;
        dst_p->value.c040 = decoder_read_bool(decoder_p);
        break;

    case 40:
        dst_p->choice = uper_c_source_q_choice_c041_e;
        dst_p->value.c041 = decoder_read_bool(decoder_p);
        break;

    case 41:
        dst_p->choice = uper_c_source_q_choice_c042_e;
        dst_p->value.c042 = decoder_read_bool(decoder_p);
        break;

    case 42:
        dst_p->choice = uper_c_source_q_choice_c043_e;
        dst_p->value.c043 = decoder_read_bool(decoder_p);
        break;

    case 43:
        dst_p->choice = uper_c_source_q_choice_c044_e;
        dst_p->value.c044 = decoder_read_bool(decoder_p);
        break;

    case 44:
        dst_p->choice = uper_c_source_q_choice_c045_e;
        dst_p->value.c045 = decoder_read_bool(decoder_p);
        break;

    case 45:
        dst_p->choice = uper_c_source_q_choice_c046_e;
        dst_p->value.c046 = decoder_read_bool(decoder_p);
        break;

    case 46:
        dst_p->choice = uper_c_source_q_choice_c047_e;
        dst_p->value.c047 = decoder_read_bool(decoder_p);
        break;

    case 47:
        dst_p->choice = uper_c_source_q_choice_c048_e;
        dst_p->value.c048 = decoder_read_bool(decoder_p);
        break;

    case 48:
        dst_p->choice = uper_c_source_q_choice_c049_e;
        dst_p->value.c049 = decoder_read_bool(decoder_p);
        break;

    case 49:
        dst_p->choice = uper_c_source_q_choice_c050_e;
        dst_p->value.c050 = decoder_read_bool(decoder_p);
        break;

    case 50:
        dst_p->choice = uper_c_source_q_choice_c051_e;
        dst_p->value.c051 = decoder_read_bool(decoder_p);
        break;

    case 51:
        dst_p->choice = uper_c_source_q_choice_c052_e;
        dst_p->value.c052 = decoder_read_bool(decoder_p);
        break;

    case 52:
        dst_p->choice = uper_c_source_q_choice_c053_e;
        dst_p->value.c053 = decoder_read_bool(decoder_p);
        break;

    case 53:
        dst_p->choice = uper_c_source_q_choice_c054_e;
        dst_p->value.c054 = decoder_read_bool(decoder_p);
        break;

    case 54:
        dst_p->choice = uper_c_source_q_choice_c055_e;
        dst_p->value.c055 = decoder_read_bool(decoder_p);
        break;

    case 55:
        dst_p->choice = uper_c_source_q_choice_c056_e;
        dst_p->value.c056 = decoder_read_bool(decoder_p);
        break;

    case 56:
        dst_p->choice = uper_c_source_q_choice_c057_e;
        dst_p->value.c057 = decoder_read_bool(decoder_p);
        break;

    case 57:
        dst_p->choice = uper_c_source_q_choice_c058_e;
        dst_p->value.c058 = decoder_read_bool(decoder_p);
        break;

    case 58:
        dst_p->choice = uper_c_source_q_choice_c059_e;
        dst_p->value.c059 = decoder_read_bool(decoder_p);
        break;

    case 59:
        dst_p->choice = uper_c_source_q_choice_c060_e;
        dst_p->value.c060 = decoder_read_bool(decoder_p);
        break;

    case 60:
        dst_p->choice = uper_c_source_q_choice_c061_e;
        dst_p->value.c061 = decoder_read_bool(decoder_p);
        break;

    case 61:
        dst_p->choice = uper_c_source_q_choice_c062_e;
        dst_p->value.c062 = decoder_read_bool(decoder_p);
        break;

    case 62:
        dst_p->choice = uper_c_source_q_choice_c063_e;
        dst_p->value.c063 = decoder_read_bool(decoder_p);
        break;

    case 63:
        dst_p->choice = uper_c_source_q_choice_c064_e;
        dst_p->value.c064 = decoder_read_bool(decoder_p);
        break;

    case 64:
        dst_p->choice = uper_c_source_q_choice_c065_e;
        dst_p->value.c065 = decoder_read_bool(decoder_p);
        break;

    case 65:
        dst_p->choice = uper_c_source_q_choice_c066_e;
        dst_p->value.c066 = decoder_read_bool(decoder_p);
        break;

    case 66:
        dst_p->choice = uper_c_source_q_choice_c067_e;
        dst_p->value.c067 = decoder_read_bool(decoder_p);
        break;

    case 67:
        dst_p->choice = uper_c_source_q_choice_c068_e;
        dst_p->value.c068 = decoder_read_bool(decoder_p);
        break;

    case 68:
        dst_p->choice = uper_c_source_q_choice_c069_e;
        dst_p->value.c069 = decoder_read_bool(decoder_p);
        break;

    case 69:
        dst_p->choice = uper_c_source_q_choice_c070_e;
        dst_p->value.c070 = decoder_read_bool(decoder_p);
        break;

    case 70:
        dst_p->choice = uper_c_source_q_choice_c071_e;
        dst_p->value.c071 = decoder_read_bool(decoder_p);
        break;

    case 71:
        dst_p->choice = uper_c_source_q_choice_c072_e;
        dst_p->value.c072 = decoder_read_bool(decoder_p);
        break;

    case 72:
        dst_p->choice = uper_c_source_q_choice_c073_e;
        dst_p->value.c073 = decoder_read_bool(decoder_p);
        break;

    case 73:
        dst_p->choice = uper_c_source_q_choice_c074_e;
        dst_p->value.c074 = decoder_read_bool(decoder_p);
        break;

    case 74:
        dst_p->choice = uper_c_source_q_choice_c075_e;
        dst_p->value.c075 = decoder_read_bool(decoder_p);
        break;

    case 75:
        dst_p->choice = uper_c_source_q_choice_c076_e;
        dst_p->value.c076 = decoder_read_bool(decoder_p);
        break;

    case 76:
        dst_p->choice = uper_c_source_q_choice_c077_e;
        dst_p->value.c077 = decoder_read_bool(decoder_p);
        break;

    case 77:
        dst_p->choice = uper_c_source_q_choice_c078_e;
        dst_p->value.c078 = decoder_read_bool(decoder_p);
        break;

    case 78:
        dst_p->choice = uper_c_source_q_choice_c079_e;
        dst_p->value.c079 = decoder_read_bool(decoder_p);
        break;

    case 79:
        dst_p->choice = uper_c_source_q_choice_c080_e;
        dst_p->value.c080 = decoder_read_bool(decoder_p);
        break;

    case 80:
        dst_p->choice = uper_c_source_q_choice_c081_e;
        dst_p->value.c081 = decoder_read_bool(decoder_p);
        break;

    case 81:
        dst_p->choice = uper_c_source_q_choice_c082_e;
        dst_p->value.c082 = decoder_read_bool(decoder_p);
        break;

    case 82:
        dst_p->choice = uper_c_source_q_choice_c083_e;
        dst_p->value.c083 = decoder_read_bool(decoder_p);
        break;

    case 83:
        dst_p->choice = uper_c_source_q_choice_c084_e;
        dst_p->value.c084 = decoder_read_bool(decoder_p);
        break;

    case 84:
        dst_p->choice = uper_c_source_q_choice_c085_e;
        dst_p->value.c085 = decoder_read_bool(decoder_p);
        break;

    case 85:
        dst_p->choice = uper_c_source_q_choice_c086_e;
        dst_p->value.c086 = decoder_read_bool(decoder_p);
        break;

    case 86:
        dst_p->choice = uper_c_source_q_choice_c087_e;
        dst_p->value.c087 = decoder_read_bool(decoder_p);
        break;

    case 87:
        dst_p->choice = uper_c_source_q_choice_c088_e;
        dst_p->value.c088 = decoder_read_bool(decoder_p);
        break;

    case 88:
        dst_p->choice = uper_c_source_q_choice_c089_e;
        dst_p->value.c089 = decoder_read_bool(decoder_p);
        break;

    case 89:
        dst_p->choice = uper_c_source_q_choice_c090_e;
        dst_p->value.c090 = decoder_read_bool(decoder_p);
        break;

    case 90:
        dst_p->choice = uper_c_source_q_choice_c091_e;
        dst_p->value.c091 = decoder_read_bool(decoder_p);
        break;

    case 91:
        dst_p->choice = uper_c_source_q_choice_c092_e;
        dst_p->value.c092 = decoder_read_bool(decoder_p);
        break;

    case 92:
        dst_p->choice = uper_c_source_q_choice_c093_e;
        dst_p->value.c093 = decoder_read_bool(decoder_p);
        break;

    case 93:
        dst_p->choice = uper_c_source_q_choice_c094_e;
        dst_p->value.c094 = decoder_read_bool(decoder_p);
        break;

    case 94:
        dst_p->choice = uper_c_source_q_choice_c095_e;
        dst_p->value.c095 = decoder_read_bool(decoder_p);
        break;

    case 95:
        dst_p->choice = uper_c_source_q_choice_c096_e;
        dst_p->value.c096 = decoder_read_bool(decoder_p);
        break;

    case 96:
        dst_p->choice = uper_c_source_q_choice_c097_e;
        dst_p->value.c097 = decoder_read_bool(decoder_p);
        break;

    case 97:
        dst_p->choice = uper_c_source_q_choice_c098_e;
        dst_p->value.c098 = decoder_read_bool(decoder_p);
        break;

    case 98:
        dst_p->choice = uper_c_source_q_choice_c099_e;
        dst_p->value.c099 = decoder_read_bool(decoder_p);
        break;

    case 99:
        dst_p->choice = uper_c_source_q_choice_c100_e;
        dst_p->value.c100 = decoder_read_bool(decoder_p);
        break;

    case 100:
        dst_p->choice = uper_c_source_q_choice_c101_e;
        dst_p->value.c101 = decoder_read_bool(decoder_p);
        break;

    case 101:
        dst_p->choice = uper_c_source_q_choice_c102_e;
        dst_p->value.c102 = decoder_read_bool(decoder_p);
        break;

    case 102:
        dst_p->choice = uper_c_source_q_choice_c103_e;
        dst_p->value.c103 = decoder_read_bool(decoder_p);
        break;

    case 103:
        dst_p->choice = uper_c_source_q_choice_c104_e;
        dst_p->value.c104 = decoder_read_bool(decoder_p);
        break;

    case 104:
        dst_p->choice = uper_c_source_q_choice_c105_e;
        dst_p->value.c105 = decoder_read_bool(decoder_p);
        break;

    case 105:
        dst_p->choice = uper_c_source_q_choice_c106_e;
        dst_p->value.c106 = decoder_read_bool(decoder_p);
        break;

    case 106:
        dst_p->choice = uper_c_source_q_choice_c107_e;
        dst_p->value.c107 = decoder_read_bool(decoder_p);
        break;

    case 107:
        dst_p->choice = uper_c_source_q_choice_c108_e;
        dst_p->value.c108 = decoder_read_bool(decoder_p);
        break;

    case 108:
        dst_p->choice = uper_c_source_q_choice_c109_e;
        dst_p->value.c109 = decoder_read_bool(decoder_p);
        break;

    case 109:
        dst_p->choice = uper_c_source_q_choice_c110_e;
        dst_p->value.c110 = decoder_read_bool(decoder_p);
        break;

    case 110:
        dst_p->choice = uper_c_source_q_choice_c111_e;
        dst_p->value.c111 = decoder_read_bool(decoder_p);
        break;

    case 111:
        dst_p->choice = uper_c_source_q_choice_c112_e;
        dst_p->value.c112 = decoder_read_bool(decoder_p);
        break;

    case 112:
        dst_p->choice = uper_c_source_q_choice_c113_e;
        dst_p->value.c113 = decoder_read_bool(decoder_p);
        break;

    case 113:
        dst_p->choice = uper_c_source_q_choice_c114_e;
        dst_p->value.c114 = decoder_read_bool(decoder_p);
        break;

    case 114:
        dst_p->choice = uper_c_source_q_choice_c115_e;
        dst_p->value.c115 = decoder_read_bool(decoder_p);
        break;

    case 115:
        dst_p->choice = uper_c_source_q_choice_c116_e;
        dst_p->value.c116 = decoder_read_bool(decoder_p);
        break;

    case 116:
        dst_p->choice = uper_c_source_q_choice_c117_e;
        dst_p->value.c117 = decoder_read_bool(decoder_p);
        break;

    case 117:
        dst_p->choice = uper_c_source_q_choice_c118_e;
        dst_p->value.c118 = decoder_read_bool(decoder_p);
        break;

    case 118:
        dst_p->choice = uper_c_source_q_choice_c119_e;
        dst_p->value.c119 = decoder_read_bool(decoder_p);
        break;

    case 119:
        dst_p->choice = uper_c_source_q_choice_c120_e;
        dst_p->value.c120 = decoder_read_bool(decoder_p);
        break;

    case 120:
        dst_p->choice = uper_c_source_q_choice_c121_e;
        dst_p->value.c121 = decoder_read_bool(decoder_p);
        break;

    case 121:
        dst_p->choice = uper_c_source_q_choice_c122_e;
        dst_p->value.c122 = decoder_read_bool(decoder_p);
        break;

    case 122:
        dst_p->choice = uper_c_source_q_choice_c123_e;
        dst_p->value.c123 = decoder_read_bool(decoder_p);
        break;

    case 123:
        dst_p->choice = uper_c_source_q_choice_c124_e;
        dst_p->value.c124 = decoder_read_bool(decoder_p);
        break;

    case 124:
        dst_p->choice = uper_c_source_q_choice_c125_e;
        dst_p->value.c125 = decoder_read_bool(decoder_p);
        break;

    case 125:
        dst_p->choice = uper_c_source_q_choice_c126_e;
        dst_p->value.c126 = decoder_read_bool(decoder_p);
        break;

    case 126:
        dst_p->choice = uper_c_source_q_choice_c127_e;
        dst_p->value.c127 = decoder_read_bool(decoder_p);
        break;

    case 127:
        dst_p->choice = uper_c_source_q_choice_c128_e;
        dst_p->value.c128 = decoder_read_bool(decoder_p);
        break;

    case 128:
        dst_p->choice = uper_c_source_q_choice_c129_e;
        dst_p->value.c129 = decoder_read_bool(decoder_p);
        break;

    case 129:
        dst_p->choice = uper_c_source_q_choice_c130_e;
        dst_p->value.c130 = decoder_read_bool(decoder_p);
        break;

    case 130:
        dst_p->choice = uper_c_source_q_choice_c131_e;
        dst_p->value.c131 = decoder_read_bool(decoder_p);
        break;

    case 131:
        dst_p->choice = uper_c_source_q_choice_c132_e;
        dst_p->value.c132 = decoder_read_bool(decoder_p);
        break;

    case 132:
        dst_p->choice = uper_c_source_q_choice_c133_e;
        dst_p->value.c133 = decoder_read_bool(decoder_p);
        break;

    case 133:
        dst_p->choice = uper_c_source_q_choice_c134_e;
        dst_p->value.c134 = decoder_read_bool(decoder_p);
        break;

    case 134:
        dst_p->choice = uper_c_source_q_choice_c135_e;
        dst_p->value.c135 = decoder_read_bool(decoder_p);
        break;

    case 135:
        dst_p->choice = uper_c_source_q_choice_c136_e;
        dst_p->value.c136 = decoder_read_bool(decoder_p);
        break;

    case 136:
        dst_p->choice = uper_c_source_q_choice_c137_e;
        dst_p->value.c137 = decoder_read_bool(decoder_p);
        break;

    case 137:
        dst_p->choice = uper_c_source_q_choice_c138_e;
        dst_p->value.c138 = decoder_read_bool(decoder_p);
        break;

    case 138:
        dst_p->choice = uper_c_source_q_choice_c139_e;
        dst_p->value.c139 = decoder_read_bool(decoder_p);
        break;

    case 139:
        dst_p->choice = uper_c_source_q_choice_c140_e;
        dst_p->value.c140 = decoder_read_bool(decoder_p);
        break;

    case 140:
        dst_p->choice = uper_c_source_q_choice_c141_e;
        dst_p->value.c141 = decoder_read_bool(decoder_p);
        break;

    case 141:
        dst_p->choice = uper_c_source_q_choice_c142_e;
        dst_p->value.c142 = decoder_read_bool(decoder_p);
        break;

    case 142:
        dst_p->choice = uper_c_source_q_choice_c143_e;
        dst_p->value.c143 = decoder_read_bool(decoder_p);
        break;

    case 143:
        dst_p->choice = uper_c_source_q_choice_c144_e;
        dst_p->value.c144 = decoder_read_bool(decoder_p);
        break;

    case 144:
        dst_p->choice = uper_c_source_q_choice_c145_e;
        dst_p->value.c145 = decoder_read_bool(decoder_p);
        break;

    case 145:
        dst_p->choice = uper_c_source_q_choice_c146_e;
        dst_p->value.c146 = decoder_read_bool(decoder_p);
        break;

    case 146:
        dst_p->choice = uper_c_source_q_choice_c147_e;
        dst_p->value.c147 = decoder_read_bool(decoder_p);
        break;

    case 147:
        dst_p->choice = uper_c_source_q_choice_c148_e;
        dst_p->value.c148 = decoder_read_bool(decoder_p);
        break;

    case 148:
        dst_p->choice = uper_c_source_q_choice_c149_e;
        dst_p->value.c149 = decoder_read_bool(decoder_p);
        break;

    case 149:
        dst_p->choice = uper_c_source_q_choice_c150_e;
        dst_p->value.c150 = decoder_read_bool(decoder_p);
        break;

    case 150:
        dst_p->choice = uper_c_source_q_choice_c151_e;
        dst_p->value.c151 = decoder_read_bool(decoder_p);
        break;

    case 151:
        dst_p->choice = uper_c_source_q_choice_c152_e;
        dst_p->value.c152 = decoder_read_bool(decoder_p);
        break;

    case 152:
        dst_p->choice = uper_c_source_q_choice_c153_e;
        dst_p->value.c153 = decoder_read_bool(decoder_p);
        break;

    case 153:
        dst_p->choice = uper_c_source_q_choice_c154_e;
        dst_p->value.c154 = decoder_read_bool(decoder_p);
        break;

    case 154:
        dst_p->choice = uper_c_source_q_choice_c155_e;
        dst_p->value.c155 = decoder_read_bool(decoder_p);
        break;

    case 155:
        dst_p->choice = uper_c_source_q_choice_c156_e;
        dst_p->value.c156 = decoder_read_bool(decoder_p);
        break;

    case 156:
        dst_p->choice = uper_c_source_q_choice_c157_e;
        dst_p->value.c157 = decoder_read_bool(decoder_p);
        break;

    case 157:
        dst_p->choice = uper_c_source_q_choice_c158_e;
        dst_p->value.c158 = decoder_read_bool(decoder_p);
        break;

    case 158:
        dst_p->choice = uper_c_source_q_choice_c159_e;
        dst_p->value.c159 = decoder_read_bool(decoder_p);
        break;

    case 159:
        dst_p->choice = uper_c_source_q_choice_c160_e;
        dst_p->value.c160 = decoder_read_bool(decoder_p);
        break;

    case 160:
        dst_p->choice = uper_c_source_q_choice_c161_e;
        dst_p->value.c161 = decoder_read_bool(decoder_p);
        break;

    case 161:
        dst_p->choice = uper_c_source_q_choice_c162_e;
        dst_p->value.c162 = decoder_read_bool(decoder_p);
        break;

    case 162:
        dst_p->choice = uper_c_source_q_choice_c163_e;
        dst_p->value.c163 = decoder_read_bool(decoder_p);
        break;

    case 163:
        dst_p->choice = uper_c_source_q_choice_c164_e;
        dst_p->value.c164 = decoder_read_bool(decoder_p);
        break;

    case 164:
        dst_p->choice = uper_c_source_q_choice_c165_e;
        dst_p->value.c165 = decoder_read_bool(decoder_p);
        break;

    case 165:
        dst_p->choice = uper_c_source_q_choice_c166_e;
        dst_p->value.c166 = decoder_read_bool(decoder_p);
        break;

    case 166:
        dst_p->choice = uper_c_source_q_choice_c167_e;
        dst_p->value.c167 = decoder_read_bool(decoder_p);
        break;

    case 167:
        dst_p->choice = uper_c_source_q_choice_c168_e;
        dst_p->value.c168 = decoder_read_bool(decoder_p);
        break;

    case 168:
        dst_p->choice = uper_c_source_q_choice_c169_e;
        dst_p->value.c169 = decoder_read_bool(decoder_p);
        break;

    case 169:
        dst_p->choice = uper_c_source_q_choice_c170_e;
        dst_p->value.c170 = decoder_read_bool(decoder_p);
        break;

    case 170:
        dst_p->choice = uper_c_source_q_choice_c171_e;
        dst_p->value.c171 = decoder_read_bool(decoder_p);
        break;

    case 171:
        dst_p->choice = uper_c_source_q_choice_c172_e;
        dst_p->value.c172 = decoder_read_bool(decoder_p);
        break;

    case 172:
        dst_p->choice = uper_c_source_q_choice_c173_e;
        dst_p->value.c173 = decoder_read_bool(decoder_p);
        break;

    case 173:
        dst_p->choice = uper_c_source_q_choice_c174_e;
        dst_p->value.c174 = decoder_read_bool(decoder_p);
        break;

    case 174:
        dst_p->choice = uper_c_source_q_choice_c175_e;
        dst_p->value.c175 = decoder_read_bool(decoder_p);
        break;

    case 175:
        dst_p->choice = uper_c_source_q_choice_c176_e;
        dst_p->value.c176 = decoder_read_bool(decoder_p);
        break;

    case 176:
        dst_p->choice = uper_c_source_q_choice_c177_e;
        dst_p->value.c177 = decoder_read_bool(decoder_p);
        break;

    case 177:
        dst_p->choice = uper_c_source_q_choice_c178_e;
        dst_p->value.c178 = decoder_read_bool(decoder_p);
        break;

    case 178:
        dst_p->choice = uper_c_source_q_choice_c179_e;
        dst_p->value.c179 = decoder_read_bool(decoder_p);
        break;

    case 179:
        dst_p->choice = uper_c_source_q_choice_c180_e;
        dst_p->value.c180 = decoder_read_bool(decoder_p);
        break;

    case 180:
        dst_p->choice = uper_c_source_q_choice_c181_e;
        dst_p->value.c181 = decoder_read_bool(decoder_p);
        break;

    case 181:
        dst_p->choice = uper_c_source_q_choice_c182_e;
        dst_p->value.c182 = decoder_read_bool(decoder_p);
        break;

    case 182:
        dst_p->choice = uper_c_source_q_choice_c183_e;
        dst_p->value.c183 = decoder_read_bool(decoder_p);
        break;

    case 183:
        dst_p->choice = uper_c_source_q_choice_c184_e;
        dst_p->value.c184 = decoder_read_bool(decoder_p);
        break;

    case 184:
        dst_p->choice = uper_c_source_q_choice_c185_e;
        dst_p->value.c185 = decoder_read_bool(decoder_p);
        break;

    case 185:
        dst_p->choice = uper_c_source_q_choice_c186_e;
        dst_p->value.c186 = decoder_read_bool(decoder_p);
        break;

    case 186:
        dst_p->choice = uper_c_source_q_choice_c187_e;
        dst_p->value.c187 = decoder_read_bool(decoder_p);
        break;

    case 187:
        dst_p->choice = uper_c_source_q_choice_c188_e;
        dst_p->value.c188 = decoder_read_bool(decoder_p);
        break;

    case 188:
        dst_p->choice = uper_c_source_q_choice_c189_e;
        dst_p->value.c189 = decoder_read_bool(decoder_p);
        break;

    case 189:
        dst_p->choice = uper_c_source_q_choice_c190_e;
        dst_p->value.c190 = decoder_read_bool(decoder_p);
        break;

    case 190:
        dst_p->choice = uper_c_source_q_choice_c191_e;
        dst_p->value.c191 = decoder_read_bool(decoder_p);
        break;

    case 191:
        dst_p->choice = uper_c_source_q_choice_c192_e;
        dst_p->value.c192 = decoder_read_bool(decoder_p);
        break;

    case 192:
        dst_p->choice = uper_c_source_q_choice_c193_e;
        dst_p->value.c193 = decoder_read_bool(decoder_p);
        break;

    case 193:
        dst_p->choice = uper_c_source_q_choice_c194_e;
        dst_p->value.c194 = decoder_read_bool(decoder_p);
        break;

    case 194:
        dst_p->choice = uper_c_source_q_choice_c195_e;
        dst_p->value.c195 = decoder_read_bool(decoder_p);
        break;

    case 195:
        dst_p->choice = uper_c_source_q_choice_c196_e;
        dst_p->value.c196 = decoder_read_bool(decoder_p);
        break;

    case 196:
        dst_p->choice = uper_c_source_q_choice_c197_e;
        dst_p->value.c197 = decoder_read_bool(decoder_p);
        break;

    case 197:
        dst_p->choice = uper_c_source_q_choice_c198_e;
        dst_p->value.c198 = decoder_read_bool(decoder_p);
        break;

    case 198:
        dst_p->choice = uper_c_source_q_choice_c199_e;
        dst_p->value.c199 = decoder_read_bool(decoder_p);
        break;

    case 199:
        dst_p->choice = uper_c_source_q_choice_c200_e;
        dst_p->value.c200 = decoder_read_bool(decoder_p);
        break;

    case 200:
        dst_p->choice = uper_c_source_q_choice_c201_e;
        dst_p->value.c201 = decoder_read_bool(decoder_p);
        break;

    case 201:
        dst_p->choice = uper_c_source_q_choice_c202_e;
        dst_p->value.c202 = decoder_read_bool(decoder_p);
        break;

    case 202:
        dst_p->choice = uper_c_source_q_choice_c203_e;
        dst_p->value.c203 = decoder_read_bool(decoder_p);
        break;

    case 203:
        dst_p->choice = uper_c_source_q_choice_c204_e;
        dst_p->value.c204 = decoder_read_bool(decoder_p);
        break;

    case 204:
        dst_p->choice = uper_c_source_q_choice_c205_e;
        dst_p->value.c205 = decoder_read_bool(decoder_p);
        break;

    case 205:
        dst_p->choice = uper_c_source_q_choice_c206_e;
        dst_p->value.c206 = decoder_read_bool(decoder_p);
        break;

    case 206:
        dst_p->choice = uper_c_source_q_choice_c207_e;
        dst_p->value.c207 = decoder_read_bool(decoder_p);
        break;

    case 207:
        dst_p->choice = uper_c_source_q_choice_c208_e;
        dst_p->value.c208 = decoder_read_bool(decoder_p);
        break;

    case 208:
        dst_p->choice = uper_c_source_q_choice_c209_e;
        dst_p->value.c209 = decoder_read_bool(decoder_p);
        break;

    case 209:
        dst_p->choice = uper_c_source_q_choice_c210_e;
        dst_p->value.c210 = decoder_read_bool(decoder_p);
        break;

    case 210:
        dst_p->choice = uper_c_source_q_choice_c211_e;
        dst_p->value.c211 = decoder_read_bool(decoder_p);
        break;

    case 211:
        dst_p->choice = uper_c_source_q_choice_c212_e;
        dst_p->value.c212 = decoder_read_bool(decoder_p);
        break;

    case 212:
        dst_p->choice = uper_c_source_q_choice_c213_e;
        dst_p->value.c213 = decoder_read_bool(decoder_p);
        break;

    case 213:
        dst_p->choice = uper_c_source_q_choice_c214_e;
        dst_p->value.c214 = decoder_read_bool(decoder_p);
        break;

    case 214:
        dst_p->choice = uper_c_source_q_choice_c215_e;
        dst_p->value.c215 = decoder_read_bool(decoder_p);
        break;

    case 215:
        dst_p->choice = uper_c_source_q_choice_c216_e;
        dst_p->value.c216 = decoder_read_bool(decoder_p);
        break;

    case 216:
        dst_p->choice = uper_c_source_q_choice_c217_e;
        dst_p->value.c217 = decoder_read_bool(decoder_p);
        break;

    case 217:
        dst_p->choice = uper_c_source_q_choice_c218_e;
        dst_p->value.c218 = decoder_read_bool(decoder_p);
        break;

    case 218:
        dst_p->choice = uper_c_source_q_choice_c219_e;
        dst_p->value.c219 = decoder_read_bool(decoder_p);
        break;

    case 219:
        dst_p->choice = uper_c_source_q_choice_c220_e;
        dst_p->value.c220 = decoder_read_bool(decoder_p);
        break;

    case 220:
        dst_p->choice = uper_c_source_q_choice_c221_e;
        dst_p->value.c221 = decoder_read_bool(decoder_p);
        break;

    case 221:
        dst_p->choice = uper_c_source_q_choice_c222_e;
        dst_p->value.c222 = decoder_read_bool(decoder_p);
        break;

    case 222:
        dst_p->choice = uper_c_source_q_choice_c223_e;
        dst_p->value.c223 = decoder_read_bool(decoder_p);
        break;

    case 223:
        dst_p->choice = uper_c_source_q_choice_c224_e;
        dst_p->value.c224 = decoder_read_bool(decoder_p);
        break;

    case 224:
        dst_p->choice = uper_c_source_q_choice_c225_e;
        dst_p->value.c225 = decoder_read_bool(decoder_p);
        break;

    case 225:
        dst_p->choice = uper_c_source_q_choice_c226_e;
        dst_p->value.c226 = decoder_read_bool(decoder_p);
        break;

    case 226:
        dst_p->choice = uper_c_source_q_choice_c227_e;
        dst_p->value.c227 = decoder_read_bool(decoder_p);
        break;

    case 227:
        dst_p->choice = uper_c_source_q_choice_c228_e;
        dst_p->value.c228 = decoder_read_bool(decoder_p);
        break;

    case 228:
        dst_p->choice = uper_c_source_q_choice_c229_e;
        dst_p->value.c229 = decoder_read_bool(decoder_p);
        break;

    case 229:
        dst_p->choice = uper_c_source_q_choice_c230_e;
        dst_p->value.c230 = decoder_read_bool(decoder_p);
        break;

    case 230:
        dst_p->choice = uper_c_source_q_choice_c231_e;
        dst_p->value.c231 = decoder_read_bool(decoder_p);
        break;

    case 231:
        dst_p->choice = uper_c_source_q_choice_c232_e;
        dst_p->value.c232 = decoder_read_bool(decoder_p);
        break;

    case 232:
        dst_p->choice = uper_c_source_q_choice_c233_e;
        dst_p->value.c233 = decoder_read_bool(decoder_p);
        break;

    case 233:
        dst_p->choice = uper_c_source_q_choice_c234_e;
        dst_p->value.c234 = decoder_read_bool(decoder_p);
        break;

    case 234:
        dst_p->choice = uper_c_source_q_choice_c235_e;
        dst_p->value.c235 = decoder_read_bool(decoder_p);
        break;

    case 235:
        dst_p->choice = uper_c_source_q_choice_c236_e;
        dst_p->value.c236 = decoder_read_bool(decoder_p);
        break;

    case 236:
        dst_p->choice = uper_c_source_q_choice_c237_e;
        dst_p->value.c237 = decoder_read_bool(decoder_p);
        break;

    case 237:
        dst_p->choice = uper_c_source_q_choice_c238_e;
        dst_p->value.c238 = decoder_read_bool(decoder_p);
        break;

    case 238:
        dst_p->choice = uper_c_source_q_choice_c239_e;
        dst_p->value.c239 = decoder_read_bool(decoder_p);
        break;

    case 239:
        dst_p->choice = uper_c_source_q_choice_c240_e;
        dst_p->value.c240 = decoder_read_bool(decoder_p);
        break;

    case 240:
        dst_p->choice = uper_c_source_q_choice_c241_e;
        dst_p->value.c241 = decoder_read_bool(decoder_p);
        break;

    case 241:
        dst_p->choice = uper_c_source_q_choice_c242_e;
        dst_p->value.c242 = decoder_read_bool(decoder_p);
        break;

    case 242:
        dst_p->choice = uper_c_source_q_choice_c243_e;
        dst_p->value.c243 = decoder_read_bool(decoder_p);
        break;

    case 243:
        dst_p->choice = uper_c_source_q_choice_c244_e;
        dst_p->value.c244 = decoder_read_bool(decoder_p);
        break;

    case 244:
        dst_p->choice = uper_c_source_q_choice_c245_e;
        dst_p->value.c245 = decoder_read_bool(decoder_p);
        break;

    case 245:
        dst_p->choice = uper_c_source_q_choice_c246_e;
        dst_p->value.c246 = decoder_read_bool(decoder_p);
        break;

    case 246:
        dst_p->choice = uper_c_source_q_choice_c247_e;
        dst_p->value.c247 = decoder_read_bool(decoder_p);
        break;

    case 247:
        dst_p->choice = uper_c_source_q_choice_c248_e;
        dst_p->value.c248 = decoder_read_bool(decoder_p);
        break;

    case 248:
        dst_p->choice = uper_c_source_q_choice_c249_e;
        dst_p->value.c249 = decoder_read_bool(decoder_p);
        break;

    case 249:
        dst_p->choice = uper_c_source_q_choice_c250_e;
        dst_p->value.c250 = decoder_read_bool(decoder_p);
        break;

    case 250:
        dst_p->choice = uper_c_source_q_choice_c251_e;
        dst_p->value.c251 = decoder_read_bool(decoder_p);
        break;

    case 251:
        dst_p->choice = uper_c_source_q_choice_c252_e;
        dst_p->value.c252 = decoder_read_bool(decoder_p);
        break;

    case 252:
        dst_p->choice = uper_c_source_q_choice_c253_e;
        dst_p->value.c253 = decoder_read_bool(decoder_p);
        break;

    case 253:
        dst_p->choice = uper_c_source_q_choice_c254_e;
        dst_p->value.c254 = decoder_read_bool(decoder_p);
        break;

    case 254:
        dst_p->choice = uper_c_source_q_choice_c255_e;
        dst_p->value.c255 = decoder_read_bool(decoder_p);
        break;

    case 255:
        dst_p->choice = uper_c_source_q_choice_c256_e;
        dst_p->value.c256 = decoder_read_bool(decoder_p);
        break;

    case 256:
        dst_p->choice = uper_c_source_q_choice_c257_e;
        dst_p->value.c257 = decoder_read_bool(decoder_p);
        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }
}

static void uper_c_source_d_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_d_t *src_p)
{
    uint8_t i;
    uint8_t i_2;
    uint16_t value;

    encoder_append_non_negative_binary_integer(
        encoder_p,
        src_p->length - 1u,
        4);

    for (i = 0; i < src_p->length; i++) {
        switch (src_p->elements[i].a.b.choice) {

        case uper_c_source_d_a_b_choice_c_e:
            encoder_append_non_negative_binary_integer(encoder_p, 0, 1);
            encoder_append_non_negative_binary_integer(
                encoder_p,
                (uint64_t)(src_p->elements[i].a.b.value.c - 0),
                1);
            break;

        case uper_c_source_d_a_b_choice_d_e:
            encoder_append_non_negative_binary_integer(encoder_p, 1, 1);
            encoder_append_bool(encoder_p, src_p->elements[i].a.b.value.d);
            break;

        default:
            encoder_abort(encoder_p, EBADCHOICE);
            break;
        }

        encoder_append_non_negative_binary_integer(
            encoder_p,
            src_p->elements[i].a.e.length - 3u,
            1);

        for (i_2 = 0; i_2 < src_p->elements[i].a.e.length; i_2++) {
        }

        encoder_append_bool(encoder_p, src_p->elements[i].g.h != uper_c_source_d_g_h_j_e);

        if (src_p->elements[i].g.h != uper_c_source_d_g_h_j_e) {
            switch (src_p->elements[i].g.h) {
            case uper_c_source_d_g_h_i_e:
                value = 0;
                break;
            case uper_c_source_d_g_h_j_e:
                value = 1;
                break;
            case uper_c_source_d_g_h_k_e:
                value = 2;
                break;
            default:
                encoder_abort(encoder_p, EBADENUM);
                return;
            }
            encoder_append_non_negative_binary_integer(encoder_p, value, 2);
        }

        encoder_append_non_negative_binary_integer(
            encoder_p,
            src_p->elements[i].g.l.length - 1u,
            1);
        encoder_append_bytes(encoder_p,
                             &src_p->elements[i].g.l.buf[0],
                             src_p->elements[i].g.l.length);
        encoder_append_bool(encoder_p, src_p->elements[i].m.is_n_present);
        encoder_append_bool(encoder_p, src_p->elements[i].m.o != 3);
        encoder_append_bool(encoder_p, src_p->elements[i].m.is_p_present);
        encoder_append_bool(encoder_p, src_p->elements[i].m.s != false);

        if (src_p->elements[i].m.is_n_present) {
            encoder_append_bool(encoder_p, src_p->elements[i].m.n);
        }

        if (src_p->elements[i].m.o != 3) {
            encoder_append_non_negative_binary_integer(
                encoder_p,
                (uint64_t)(src_p->elements[i].m.o - -2),
                3);
        }

        if (src_p->elements[i].m.is_p_present) {
            encoder_append_bool(encoder_p, src_p->elements[i].m.p.is_r_present);
            encoder_append_bytes(encoder_p,
                                 &src_p->elements[i].m.p.q.buf[0],
                                 5);

            if (src_p->elements[i].m.p.is_r_present) {
                encoder_append_bool(encoder_p, src_p->elements[i].m.p.r);
            }
        }

        if (src_p->elements[i].m.s != false) {
            encoder_append_bool(encoder_p, src_p->elements[i].m.s);
        }
    }
}

static void uper_c_source_d_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_d_t *dst_p)
{
    uint8_t i;
    uint8_t choice;
    uint8_t i_2;
    bool is_present;
    uint16_t value;
    bool is_present_2;
    bool is_present_3;

    dst_p->length = decoder_read_non_negative_binary_integer(
        decoder_p,
        4);
    dst_p->length += 1u;

    if (dst_p->length > 10u) {
        decoder_abort(decoder_p, EBADLENGTH);

        return;
    }

    for (i = 0; i < dst_p->length; i++) {
        choice = (uint8_t)decoder_read_non_negative_binary_integer(decoder_p, 1);

        switch (choice) {

        case 0:
            dst_p->elements[i].a.b.choice = uper_c_source_d_a_b_choice_c_e;
            dst_p->elements[i].a.b.value.c = decoder_read_non_negative_binary_integer(
                decoder_p,
                1);
            dst_p->elements[i].a.b.value.c += 0;
            break;

        case 1:
            dst_p->elements[i].a.b.choice = uper_c_source_d_a_b_choice_d_e;
            dst_p->elements[i].a.b.value.d = decoder_read_bool(decoder_p);
            break;

        default:
            decoder_abort(decoder_p, EBADCHOICE);
            break;
        }

        dst_p->elements[i].a.e.length = decoder_read_non_negative_binary_integer(
            decoder_p,
            1);
        dst_p->elements[i].a.e.length += 3u;

        for (i_2 = 0; i_2 < dst_p->elements[i].a.e.length; i_2++) {
        }

        is_present = decoder_read_bool(decoder_p);

        if (is_present) {
            value = decoder_read_non_negative_binary_integer(decoder_p, 2);
            switch (value) {
            case 0:
                dst_p->elements[i].g.h = uper_c_source_d_g_h_i_e;
                break;
            case 1:
                dst_p->elements[i].g.h = uper_c_source_d_g_h_j_e;
                break;
            case 2:
                dst_p->elements[i].g.h = uper_c_source_d_g_h_k_e;
                break;
            default:
                decoder_abort(decoder_p, EBADENUM);
                return;
            }
        } else {
            dst_p->elements[i].g.h = uper_c_source_d_g_h_j_e;
        }

        dst_p->elements[i].g.l.length = decoder_read_non_negative_binary_integer(
            decoder_p,
            1);
        dst_p->elements[i].g.l.length += 1u;
        decoder_read_bytes(decoder_p,
                           &dst_p->elements[i].g.l.buf[0],
                           dst_p->elements[i].g.l.length);
        dst_p->elements[i].m.is_n_present = decoder_read_bool(decoder_p);
        is_present_2 = decoder_read_bool(decoder_p);
        dst_p->elements[i].m.is_p_present = decoder_read_bool(decoder_p);
        is_present_3 = decoder_read_bool(decoder_p);

        if (dst_p->elements[i].m.is_n_present) {
            dst_p->elements[i].m.n = decoder_read_bool(decoder_p);
        }

        if (is_present_2) {
            dst_p->elements[i].m.o = decoder_read_non_negative_binary_integer(
                decoder_p,
                3);
            dst_p->elements[i].m.o += -2;
        } else {
            dst_p->elements[i].m.o = 3;
        }

        if (dst_p->elements[i].m.is_p_present) {
            dst_p->elements[i].m.p.is_r_present = decoder_read_bool(decoder_p);
            decoder_read_bytes(decoder_p,
                               &dst_p->elements[i].m.p.q.buf[0],
                               5);

            if (dst_p->elements[i].m.p.is_r_present) {
                dst_p->elements[i].m.p.r = decoder_read_bool(decoder_p);
            }
        }

        if (is_present_3) {
            dst_p->elements[i].m.s = decoder_read_bool(decoder_p);
        } else {
            dst_p->elements[i].m.s = false;
        }
    }
}

static void uper_c_source_ac_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ac_t *src_p)
{
    uper_c_source_q_encode_inner(encoder_p, &src_p->a);
    uper_c_source_d_encode_inner(encoder_p, &src_p->b);
}

static void uper_c_source_ac_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ac_t *dst_p)
{
    uper_c_source_q_decode_inner(decoder_p, &dst_p->a);
    uper_c_source_d_decode_inner(decoder_p, &dst_p->b);
}

static void uper_c_source_ad_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ad_t *src_p)
{
    uint8_t value;

    value = src_p->value;
    encoder_append_non_negative_binary_integer(encoder_p, value, 1);
}

static void uper_c_source_ad_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ad_t *dst_p)
{
    uint8_t value;

    value = decoder_read_non_negative_binary_integer(decoder_p, 1);
    dst_p->value = (enum uper_c_source_ad_e)value;
}

static void uper_c_source_ae_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ae_t *src_p)
{
    encoder_append_bool(encoder_p, false);
    encoder_append_bool(encoder_p, src_p->is_a_present);
    encoder_append_bool(encoder_p, src_p->b != true);

    if (src_p->is_a_present) {
        encoder_append_bool(encoder_p, src_p->a);
    }

    if (src_p->b != true) {
        encoder_append_bool(encoder_p, src_p->b);
    }

    encoder_append_bool(encoder_p, src_p->c);
}

static void uper_c_source_ae_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ae_t *dst_p)
{
    bool is_present;

    decoder_read_bool(decoder_p);
    dst_p->is_a_present = decoder_read_bool(decoder_p);
    is_present = decoder_read_bool(decoder_p);

    if (dst_p->is_a_present) {
        dst_p->a = decoder_read_bool(decoder_p);
    }

    if (is_present) {
        dst_p->b = decoder_read_bool(decoder_p);
    } else {
        dst_p->b = true;
    }

    dst_p->c = decoder_read_bool(decoder_p);
}

static void uper_c_source_ah_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ah_t *src_p)
{
    if(src_p->is_d_addition_present || src_p->is_e_addition_present) {
        encoder_abort(encoder_p, EINVAL);
        return;
    }
    encoder_append_bool(encoder_p, false);
    encoder_append_bool(encoder_p, src_p->c);
}

static void uper_c_source_ah_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ah_t *dst_p)
{
    bool extension_is_present;

    extension_is_present = decoder_read_bool(decoder_p);
    dst_p->c = decoder_read_bool(decoder_p);
    if(extension_is_present) {
        decoder_abort(decoder_p, EINVAL);
        return;
    }
}

static void uper_c_source_af_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_af_t *src_p)
{
    if(src_p->is_b_addition_present || src_p->is_e_addition_present || src_p->is_f_addition_present ||
       src_p->is_g_addition_present || src_p->is_h_addition_present || src_p->is_i_addition_present ||
       src_p->is_j_addition_present || src_p->is_k_addition_present || src_p->is_l_addition_present) {
        encoder_abort(encoder_p, EINVAL);
        return;
    }
    encoder_append_bool(encoder_p, false);
    encoder_append_bool(encoder_p, src_p->a);
}

static void uper_c_source_af_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_af_t *dst_p)
{
    bool extension_is_present;

    extension_is_present = decoder_read_bool(decoder_p);
    dst_p->a = decoder_read_bool(decoder_p);
    if(extension_is_present) {
        decoder_abort(decoder_p, EINVAL);
        return;
    }
}

static void uper_c_source_ag_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ag_t *src_p)
{
    if(src_p->is_b_addition_present || src_p->is_c_addition_present || src_p->is_d_addition_present ||
       src_p->is_h_addition_present || src_p->is_i_addition_present || src_p->is_j_addition_present ||
       src_p->is_m_addition_present) {
        encoder_abort(encoder_p, EINVAL);
        return;
    }
    encoder_append_bool(encoder_p, false);
    encoder_append_bool(encoder_p, src_p->a);
}

static void uper_c_source_ag_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ag_t *dst_p)
{
    bool extension_is_present;

    extension_is_present = decoder_read_bool(decoder_p);
    dst_p->a = decoder_read_bool(decoder_p);
    if(extension_is_present) {
        decoder_abort(decoder_p, EINVAL);
        return;
    }
}

static void uper_c_source_aj_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_aj_t *src_p)
{
    uint8_t value;

    value = src_p->a;
    encoder_append_non_negative_binary_integer(encoder_p, value, 1);
}

static void uper_c_source_aj_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_aj_t *dst_p)
{
    uint8_t value;

    value = decoder_read_non_negative_binary_integer(decoder_p, 1);
    dst_p->a = (enum uper_c_source_aj_a_e)value;
}

static void uper_c_source_ak_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ak_t *src_p)
{
    switch (src_p->choice) {

    case uper_c_source_ak_choice_a_e:
        encoder_append_non_negative_binary_integer(encoder_p, 0, 0);
        uper_c_source_aj_encode_inner(encoder_p, &src_p->value.a);
        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }
}

static void uper_c_source_ak_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ak_t *dst_p)
{
    uint8_t choice;

    choice = (uint8_t)decoder_read_non_negative_binary_integer(decoder_p, 0);

    switch (choice) {

    case 0:
        dst_p->choice = uper_c_source_ak_choice_a_e;
        uper_c_source_aj_decode_inner(decoder_p, &dst_p->value.a);
        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }
}

static void uper_c_source_ai_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ai_t *src_p)
{
    uper_c_source_ak_encode_inner(encoder_p, &src_p->a);
}

static void uper_c_source_ai_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ai_t *dst_p)
{
    uper_c_source_ak_decode_inner(decoder_p, &dst_p->a);
}

static void uper_c_source_al_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_al_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value - -129),
        9);
}

static void uper_c_source_al_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_al_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        9);
    dst_p->value += -129;
}

static void uper_c_source_am_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_am_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value - -2),
        8);
}

static void uper_c_source_am_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_am_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        8);
    dst_p->value += -2;
}

static void uper_c_source_an_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_an_t *src_p)
{
    uint32_t value;

    switch (src_p->value) {
    case uper_c_source_an_a_e:
        value = 0;
        break;
    case uper_c_source_an_b_e:
        value = 1;
        break;
    case uper_c_source_an_c_e:
        value = 2;
        break;
    case uper_c_source_an_d_e:
        value = 3;
        break;
    case uper_c_source_an_e_e:
        value = 4;
        break;
    case uper_c_source_an_f_e:
        value = 5;
        break;
    case uper_c_source_an_g_e:
        value = 6;
        break;
    case uper_c_source_an_h_e:
        value = 7;
        break;
    case uper_c_source_an_i_e:
        value = 8;
        break;
    case uper_c_source_an_j_e:
        value = 9;
        break;
    case uper_c_source_an_k_e:
        value = 10;
        break;
    default:
        encoder_abort(encoder_p, EBADENUM);
        return;
    }
    encoder_append_non_negative_binary_integer(encoder_p, value, 4);
}

static void uper_c_source_an_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_an_t *dst_p)
{
    uint32_t value;

    value = decoder_read_non_negative_binary_integer(decoder_p, 4);
    switch (value) {
    case 0:
        dst_p->value = uper_c_source_an_a_e;
        break;
    case 1:
        dst_p->value = uper_c_source_an_b_e;
        break;
    case 2:
        dst_p->value = uper_c_source_an_c_e;
        break;
    case 3:
        dst_p->value = uper_c_source_an_d_e;
        break;
    case 4:
        dst_p->value = uper_c_source_an_e_e;
        break;
    case 5:
        dst_p->value = uper_c_source_an_f_e;
        break;
    case 6:
        dst_p->value = uper_c_source_an_g_e;
        break;
    case 7:
        dst_p->value = uper_c_source_an_h_e;
        break;
    case 8:
        dst_p->value = uper_c_source_an_i_e;
        break;
    case 9:
        dst_p->value = uper_c_source_an_j_e;
        break;
    case 10:
        dst_p->value = uper_c_source_an_k_e;
        break;
    default:
        decoder_abort(decoder_p, EBADENUM);
        return;
    }
}

static void uper_c_source_ao_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ao_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->a),
        8);
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->b),
        24);
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->c),
        4);
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->d),
        32);
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->e),
        64);
}

static void uper_c_source_ao_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ao_t *dst_p)
{
    dst_p->a = decoder_read_non_negative_binary_integer(
        decoder_p,
        8);
    dst_p->b = decoder_read_non_negative_binary_integer(
        decoder_p,
        24);
    dst_p->c = decoder_read_non_negative_binary_integer(
        decoder_p,
        4);
    dst_p->d = decoder_read_non_negative_binary_integer(
        decoder_p,
        32);
    dst_p->e = decoder_read_non_negative_binary_integer(
        decoder_p,
        64);
}

static void uper_c_ref_referenced_sequence_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_ref_referenced_sequence_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->a - 0),
        7);
}

static void uper_c_ref_referenced_sequence_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_ref_referenced_sequence_t *dst_p)
{
    dst_p->a = decoder_read_non_negative_binary_integer(
        decoder_p,
        7);
    dst_p->a += 0;
}

static void uper_c_ref_referenced_enum_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_ref_referenced_enum_t *src_p)
{
    uint8_t value;

    value = src_p->value;
    encoder_append_non_negative_binary_integer(encoder_p, value, 2);
}

static void uper_c_ref_referenced_enum_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_ref_referenced_enum_t *dst_p)
{
    uint8_t value;

    value = decoder_read_non_negative_binary_integer(decoder_p, 2);

    if (value > 2u) {
        decoder_abort(decoder_p, EBADENUM);

        return;
    }

    dst_p->value = (enum uper_c_ref_referenced_enum_e)value;
}

static void uper_c_source_ap_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ap_t *src_p)
{
    encoder_append_bool(encoder_p, src_p->c.value != uper_c_ref_referenced_enum_a_e);
    encoder_append_bool(encoder_p, src_p->d != 1);
    uper_c_ref_referenced_sequence_encode_inner(encoder_p, &src_p->b);

    if (src_p->c.value != uper_c_ref_referenced_enum_a_e) {
        uper_c_ref_referenced_enum_encode_inner(encoder_p, &src_p->c);
    }

    if (src_p->d != 1) {
        encoder_append_uint8(encoder_p, src_p->d);
    }
}

static void uper_c_source_ap_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ap_t *dst_p)
{
    bool is_present;
    bool is_present_2;

    is_present = decoder_read_bool(decoder_p);
    is_present_2 = decoder_read_bool(decoder_p);
    uper_c_ref_referenced_sequence_decode_inner(decoder_p, &dst_p->b);

    if (is_present) {
        uper_c_ref_referenced_enum_decode_inner(decoder_p, &dst_p->c);
    } else {
        dst_p->c.value = uper_c_ref_referenced_enum_a_e;
    }

    if (is_present_2) {
        dst_p->d = decoder_read_uint8(decoder_p);
    } else {
        dst_p->d = 1;
    }
}

static void uper_c_source_aq_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_aq_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value - 0),
        24);
}

static void uper_c_source_aq_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_aq_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        24);
    dst_p->value += 0;
}

static void uper_c_source_ar_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_ar_t *src_p)
{
    static const uint8_t a_default[] = {0xAB, 0xCD};

    encoder_append_bool(encoder_p, (memcmp(src_p->a.buf, a_default, sizeof(a_default)) != 0) ||
                                   (src_p->a.length != sizeof(a_default)));

    if ((memcmp(src_p->a.buf, a_default, sizeof(a_default)) != 0) ||
        (src_p->a.length != sizeof(a_default))) {
        encoder_append_non_negative_binary_integer(
            encoder_p,
            src_p->a.length - 0u,
            4);
        encoder_append_bytes(encoder_p,
                             &src_p->a.buf[0],
                             src_p->a.length);
    }
}

static void uper_c_source_ar_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_ar_t *dst_p)
{
    bool is_present;
    static const uint8_t a_default[] = {0xAB, 0xCD};

    is_present = decoder_read_bool(decoder_p);

    if (is_present) {
        dst_p->a.length = decoder_read_non_negative_binary_integer(
            decoder_p,
            4);
        dst_p->a.length += 0u;

        if (dst_p->a.length > 10u) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }

        decoder_read_bytes(decoder_p,
                           &dst_p->a.buf[0],
                           dst_p->a.length);
    } else {
        memcpy(dst_p->a.buf, a_default, sizeof(a_default));
        dst_p->a.length = sizeof(a_default);
    }
}

static void uper_c_source_as_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_as_t *src_p)
{
    encoder_append_bool(encoder_p, src_p->is_a_a_present);
    encoder_append_bool(encoder_p, src_p->a_c != true);

    if (src_p->is_a_a_present) {
        encoder_append_bool(encoder_p, src_p->a_a);
    }

    switch (src_p->a_b.choice) {

    case uper_c_source_as_a_b_choice_b_a_e:
        encoder_append_non_negative_binary_integer(encoder_p, 0, 1);
        encoder_append_bool(encoder_p, src_p->a_b.value.b_a);
        break;

    case uper_c_source_as_a_b_choice_b_b_e:
        encoder_append_non_negative_binary_integer(encoder_p, 1, 1);
        encoder_append_bool(encoder_p, src_p->a_b.value.b_b);
        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }

    if (src_p->a_c != true) {
        encoder_append_bool(encoder_p, src_p->a_c);
    }
}

static void uper_c_source_as_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_as_t *dst_p)
{
    bool is_present;
    uint8_t choice;

    dst_p->is_a_a_present = decoder_read_bool(decoder_p);
    is_present = decoder_read_bool(decoder_p);

    if (dst_p->is_a_a_present) {
        dst_p->a_a = decoder_read_bool(decoder_p);
    }

    choice = (uint8_t)decoder_read_non_negative_binary_integer(decoder_p, 1);

    switch (choice) {

    case 0:
        dst_p->a_b.choice = uper_c_source_as_a_b_choice_b_a_e;
        dst_p->a_b.value.b_a = decoder_read_bool(decoder_p);
        break;

    case 1:
        dst_p->a_b.choice = uper_c_source_as_a_b_choice_b_b_e;
        dst_p->a_b.value.b_b = decoder_read_bool(decoder_p);
        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }

    if (is_present) {
        dst_p->a_c = decoder_read_bool(decoder_p);
    } else {
        dst_p->a_c = true;
    }
}

static void uper_c_ref_at_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_ref_at_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value),
        2);
}

static void uper_c_ref_at_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_ref_at_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        2);
}

static void uper_c_ref_au_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_ref_au_t *src_p)
{
    uint8_t value;
    uint8_t value_2;

    switch (src_p->a_a.choice) {

    case uper_c_ref_au_a_a_choice_b_a_e:
        encoder_append_non_negative_binary_integer(encoder_p, 0, 1);
        value = src_p->a_a.value.b_a;
        encoder_append_non_negative_binary_integer(encoder_p, value, 1);
        break;

    case uper_c_ref_au_a_a_choice_b_b_e:
        encoder_append_non_negative_binary_integer(encoder_p, 1, 1);
        value_2 = src_p->a_a.value.b_b;
        encoder_append_non_negative_binary_integer(encoder_p, value_2, 1);
        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }
}

static void uper_c_ref_au_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_ref_au_t *dst_p)
{
    uint8_t choice;
    uint8_t value;
    uint8_t value_2;

    choice = (uint8_t)decoder_read_non_negative_binary_integer(decoder_p, 1);

    switch (choice) {

    case 0:
        dst_p->a_a.choice = uper_c_ref_au_a_a_choice_b_a_e;
        value = decoder_read_non_negative_binary_integer(decoder_p, 1);
        dst_p->a_a.value.b_a = (enum uper_c_ref_au_a_a_b_a_e)value;
        break;

    case 1:
        dst_p->a_a.choice = uper_c_ref_au_a_a_choice_b_b_e;
        value_2 = decoder_read_non_negative_binary_integer(decoder_p, 1);
        dst_p->a_a.value.b_b = (enum uper_c_ref_au_a_a_b_b_e)value_2;
        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }
}

static void uper_c_source_b_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_b_t *src_p)
{
    switch (src_p->choice) {

    case uper_c_source_b_choice_a_e:
        encoder_append_non_negative_binary_integer(encoder_p, 0, 2);
        encoder_append_int8(encoder_p, src_p->value.a);
        break;

    case uper_c_source_b_choice_b_e:
        encoder_append_non_negative_binary_integer(encoder_p, 1, 2);
        uper_c_source_a_encode_inner(encoder_p, &src_p->value.b);
        break;

    case uper_c_source_b_choice_c_e:
        encoder_append_non_negative_binary_integer(encoder_p, 2, 2);
        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }
}

static void uper_c_source_b_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_b_t *dst_p)
{
    uint8_t choice;

    choice = (uint8_t)decoder_read_non_negative_binary_integer(decoder_p, 2);

    switch (choice) {

    case 0:
        dst_p->choice = uper_c_source_b_choice_a_e;
        dst_p->value.a = decoder_read_int8(decoder_p);
        break;

    case 1:
        dst_p->choice = uper_c_source_b_choice_b_e;
        uper_c_source_a_decode_inner(decoder_p, &dst_p->value.b);
        break;

    case 2:
        dst_p->choice = uper_c_source_b_choice_c_e;
        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }
}

static void uper_c_source_c_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_c_t *src_p)
{
    uint8_t i;

    encoder_append_non_negative_binary_integer(
        encoder_p,
        src_p->length - 0u,
        2);

    for (i = 0; i < src_p->length; i++) {
        uper_c_source_b_encode_inner(encoder_p, &src_p->elements[i]);
    }
}

static void uper_c_source_c_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_c_t *dst_p)
{
    uint8_t i;

    dst_p->length = decoder_read_non_negative_binary_integer(
        decoder_p,
        2);
    dst_p->length += 0u;

    if (dst_p->length > 2u) {
        decoder_abort(decoder_p, EBADLENGTH);

        return;
    }

    for (i = 0; i < dst_p->length; i++) {
        uper_c_source_b_decode_inner(decoder_p, &dst_p->elements[i]);
    }
}

static void uper_c_source_e_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_e_t *src_p)
{
    switch (src_p->a.choice) {

    case uper_c_source_e_a_choice_b_e:
        encoder_append_non_negative_binary_integer(encoder_p, 0, 0);

        switch (src_p->a.value.b.choice) {

        case uper_c_source_e_a_b_choice_c_e:
            encoder_append_non_negative_binary_integer(encoder_p, 0, 0);
            encoder_append_bool(encoder_p, src_p->a.value.b.value.c);
            break;

        default:
            encoder_abort(encoder_p, EBADCHOICE);
            break;
        }

        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }
}

static void uper_c_source_e_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_e_t *dst_p)
{
    uint8_t choice;
    uint8_t choice_2;

    choice = (uint8_t)decoder_read_non_negative_binary_integer(decoder_p, 0);

    switch (choice) {

    case 0:
        dst_p->a.choice = uper_c_source_e_a_choice_b_e;
        choice_2 = (uint8_t)decoder_read_non_negative_binary_integer(decoder_p, 0);

        switch (choice_2) {

        case 0:
            dst_p->a.value.b.choice = uper_c_source_e_a_b_choice_c_e;
            dst_p->a.value.b.value.c = decoder_read_bool(decoder_p);
            break;

        default:
            decoder_abort(decoder_p, EBADCHOICE);
            break;
        }

        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }
}

static void uper_c_source_f_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_f_t *src_p)
{
    uint8_t i;
    uint8_t i_2;

    encoder_append_non_negative_binary_integer(
        encoder_p,
        src_p->length - 1u,
        1);

    for (i = 0; i < src_p->length; i++) {
        for (i_2 = 0; i_2 < 1; i_2++) {
            encoder_append_bool(encoder_p, src_p->elements[i].elements[i_2]);
        }
    }
}

static void uper_c_source_f_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_f_t *dst_p)
{
    uint8_t i;
    uint8_t i_2;

    dst_p->length = decoder_read_non_negative_binary_integer(
        decoder_p,
        1);
    dst_p->length += 1u;

    for (i = 0; i < dst_p->length; i++) {
        for (i_2 = 0; i_2 < 1; i_2++) {
            dst_p->elements[i].elements[i_2] = decoder_read_bool(decoder_p);
        }
    }
}

static void uper_c_source_g_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_g_t *src_p)
{
    encoder_append_bool(encoder_p, src_p->is_a_present);
    encoder_append_bool(encoder_p, src_p->is_b_present);
    encoder_append_bool(encoder_p, src_p->is_c_present);
    encoder_append_bool(encoder_p, src_p->is_d_present);
    encoder_append_bool(encoder_p, src_p->is_e_present);
    encoder_append_bool(encoder_p, src_p->is_f_present);
    encoder_append_bool(encoder_p, src_p->is_g_present);
    encoder_append_bool(encoder_p, src_p->is_h_present);
    encoder_append_bool(encoder_p, src_p->is_i_present);

    if (src_p->is_a_present) {
        encoder_append_bool(encoder_p, src_p->a);
    }

    if (src_p->is_b_present) {
        encoder_append_bool(encoder_p, src_p->b);
    }

    if (src_p->is_c_present) {
        encoder_append_bool(encoder_p, src_p->c);
    }

    if (src_p->is_d_present) {
        encoder_append_bool(encoder_p, src_p->d);
    }

    if (src_p->is_e_present) {
        encoder_append_bool(encoder_p, src_p->e);
    }

    if (src_p->is_f_present) {
        encoder_append_bool(encoder_p, src_p->f);
    }

    if (src_p->is_g_present) {
        encoder_append_bool(encoder_p, src_p->g);
    }

    if (src_p->is_h_present) {
        encoder_append_bool(encoder_p, src_p->h);
    }

    if (src_p->is_i_present) {
        encoder_append_bool(encoder_p, src_p->i);
    }
}

static void uper_c_source_g_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_g_t *dst_p)
{
    dst_p->is_a_present = decoder_read_bool(decoder_p);
    dst_p->is_b_present = decoder_read_bool(decoder_p);
    dst_p->is_c_present = decoder_read_bool(decoder_p);
    dst_p->is_d_present = decoder_read_bool(decoder_p);
    dst_p->is_e_present = decoder_read_bool(decoder_p);
    dst_p->is_f_present = decoder_read_bool(decoder_p);
    dst_p->is_g_present = decoder_read_bool(decoder_p);
    dst_p->is_h_present = decoder_read_bool(decoder_p);
    dst_p->is_i_present = decoder_read_bool(decoder_p);

    if (dst_p->is_a_present) {
        dst_p->a = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_b_present) {
        dst_p->b = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_c_present) {
        dst_p->c = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_d_present) {
        dst_p->d = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_e_present) {
        dst_p->e = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_f_present) {
        dst_p->f = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_g_present) {
        dst_p->g = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_h_present) {
        dst_p->h = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_i_present) {
        dst_p->i = decoder_read_bool(decoder_p);
    }
}

static void uper_c_source_h_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_h_t *src_p)
{
    (void)encoder_p;
    (void)src_p;
}

static void uper_c_source_h_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_h_t *dst_p)
{
    (void)decoder_p;
    (void)dst_p;
}

static void uper_c_source_i_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_i_t *src_p)
{
    encoder_append_bytes(encoder_p,
                         &src_p->buf[0],
                         24);
}

static void uper_c_source_i_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_i_t *dst_p)
{
    decoder_read_bytes(decoder_p,
                       &dst_p->buf[0],
                       24);
}

static void uper_c_source_j_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_j_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        src_p->length - 22u,
        1);
    encoder_append_bytes(encoder_p,
                         &src_p->buf[0],
                         src_p->length);
}

static void uper_c_source_j_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_j_t *dst_p)
{
    dst_p->length = decoder_read_non_negative_binary_integer(
        decoder_p,
        1);
    dst_p->length += 22u;
    decoder_read_bytes(decoder_p,
                       &dst_p->buf[0],
                       dst_p->length);
}

static void uper_c_source_k_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_k_t *src_p)
{
    uint8_t value;

    value = src_p->value;
    encoder_append_non_negative_binary_integer(encoder_p, value, 0);
}

static void uper_c_source_k_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_k_t *dst_p)
{
    uint8_t value;

    value = decoder_read_non_negative_binary_integer(decoder_p, 0);
    dst_p->value = (enum uper_c_source_k_e)value;
}

static void uper_c_source_l_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_l_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        src_p->length - 0u,
        9);
    encoder_append_bytes(encoder_p,
                         &src_p->buf[0],
                         src_p->length);
}

static void uper_c_source_l_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_l_t *dst_p)
{
    dst_p->length = decoder_read_non_negative_binary_integer(
        decoder_p,
        9);
    dst_p->length += 0u;

    if (dst_p->length > 500u) {
        decoder_abort(decoder_p, EBADLENGTH);

        return;
    }

    decoder_read_bytes(decoder_p,
                       &dst_p->buf[0],
                       dst_p->length);
}

static void uper_c_source_o_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_o_t *src_p)
{
    uint16_t i;

    encoder_append_non_negative_binary_integer(
        encoder_p,
        src_p->length - 1u,
        9);

    for (i = 0; i < src_p->length; i++) {
        encoder_append_bool(encoder_p, src_p->elements[i]);
    }
}

static void uper_c_source_o_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_o_t *dst_p)
{
    uint16_t i;

    dst_p->length = decoder_read_non_negative_binary_integer(
        decoder_p,
        9);
    dst_p->length += 1u;

    if (dst_p->length > 260u) {
        decoder_abort(decoder_p, EBADLENGTH);

        return;
    }

    for (i = 0; i < dst_p->length; i++) {
        dst_p->elements[i] = decoder_read_bool(decoder_p);
    }
}

static void uper_c_source_n_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_n_t *src_p)
{
    uper_c_source_k_encode_inner(encoder_p, &src_p->a);
    uper_c_source_a_encode_inner(encoder_p, &src_p->b);
    uper_c_source_o_encode_inner(encoder_p, &src_p->c);
}

static void uper_c_source_n_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_n_t *dst_p)
{
    uper_c_source_k_decode_inner(decoder_p, &dst_p->a);
    uper_c_source_a_decode_inner(decoder_p, &dst_p->b);
    uper_c_source_o_decode_inner(decoder_p, &dst_p->c);
}

static void uper_c_source_m_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_m_t *src_p)
{
    uper_c_source_k_encode_inner(encoder_p, &src_p->a);
    uper_c_source_n_encode_inner(encoder_p, &src_p->b);
}

static void uper_c_source_m_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_m_t *dst_p)
{
    uper_c_source_k_decode_inner(decoder_p, &dst_p->a);
    uper_c_source_n_decode_inner(decoder_p, &dst_p->b);
}

static void uper_c_source_p_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_p_t *src_p)
{
    uper_c_source_a_encode_inner(encoder_p, &src_p->a);
    uper_c_source_m_encode_inner(encoder_p, &src_p->b);
    uper_c_source_f_encode_inner(encoder_p, &src_p->c);
}

static void uper_c_source_p_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_p_t *dst_p)
{
    uper_c_source_a_decode_inner(decoder_p, &dst_p->a);
    uper_c_source_m_decode_inner(decoder_p, &dst_p->b);
    uper_c_source_f_decode_inner(decoder_p, &dst_p->c);
}

static void uper_c_source_r_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_r_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value - -1),
        1);
}

static void uper_c_source_r_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_r_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        1);
    dst_p->value += -1;
}

static void uper_c_ref_referenced_int_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_ref_referenced_int_t *src_p)
{
    encoder_append_uint8(encoder_p, src_p->value);
}

static void uper_c_ref_referenced_int_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_ref_referenced_int_t *dst_p)
{
    dst_p->value = decoder_read_uint8(decoder_p);
}

static void uper_c_source_s_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_s_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value - -2),
        2);
}

static void uper_c_source_s_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_s_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        2);
    dst_p->value += -2;
}

static void uper_c_source_t_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_t_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value - -1),
        2);
}

static void uper_c_source_t_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_t_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        2);
    dst_p->value += -1;
}

static void uper_c_source_u_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_u_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value - -64),
        7);
}

static void uper_c_source_u_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_u_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        7);
    dst_p->value += -64;
}

static void uper_c_source_v_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_v_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->value);
}

static void uper_c_source_v_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_v_t *dst_p)
{
    dst_p->value = decoder_read_int8(decoder_p);
}

static void uper_c_source_w_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_w_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value - -1),
        9);
}

static void uper_c_source_w_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_w_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        9);
    dst_p->value += -1;
}

static void uper_c_source_x_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_x_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value - -2),
        10);
}

static void uper_c_source_x_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_x_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        10);
    dst_p->value += -2;
}

static void uper_c_source_y_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_y_t *src_p)
{
    encoder_append_non_negative_binary_integer(
        encoder_p,
        (uint64_t)(src_p->value - 10000),
        10);
}

static void uper_c_source_y_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_y_t *dst_p)
{
    dst_p->value = decoder_read_non_negative_binary_integer(
        decoder_p,
        10);
    dst_p->value += 10000;
}

static void uper_c_source_z_encode_inner(
    struct encoder_t *encoder_p,
    const struct uper_c_source_z_t *src_p)
{
    encoder_append_bool(encoder_p, src_p->value);
}

static void uper_c_source_z_decode_inner(
    struct decoder_t *decoder_p,
    struct uper_c_source_z_t *dst_p)
{
    dst_p->value = decoder_read_bool(decoder_p);
}

ssize_t uper_c_source_a_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_a_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_a_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_a_decode(
    struct uper_c_source_a_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_a_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ab_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ab_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ab_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ab_decode(
    struct uper_c_source_ab_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ab_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_q_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_q_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_q_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_q_decode(
    struct uper_c_source_q_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_q_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_d_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_d_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_d_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_d_decode(
    struct uper_c_source_d_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_d_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ac_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ac_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ac_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ac_decode(
    struct uper_c_source_ac_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ac_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ad_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ad_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ad_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ad_decode(
    struct uper_c_source_ad_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ad_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ae_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ae_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ae_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ae_decode(
    struct uper_c_source_ae_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ae_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ah_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ah_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ah_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ah_decode(
    struct uper_c_source_ah_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ah_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_af_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_af_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_af_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_af_decode(
    struct uper_c_source_af_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_af_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ag_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ag_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ag_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ag_decode(
    struct uper_c_source_ag_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ag_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_aj_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_aj_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_aj_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_aj_decode(
    struct uper_c_source_aj_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_aj_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ak_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ak_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ak_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ak_decode(
    struct uper_c_source_ak_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ak_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ai_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ai_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ai_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ai_decode(
    struct uper_c_source_ai_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ai_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_al_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_al_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_al_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_al_decode(
    struct uper_c_source_al_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_al_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_am_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_am_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_am_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_am_decode(
    struct uper_c_source_am_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_am_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_an_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_an_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_an_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_an_decode(
    struct uper_c_source_an_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_an_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ao_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ao_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ao_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ao_decode(
    struct uper_c_source_ao_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ao_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_ref_referenced_sequence_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_ref_referenced_sequence_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_ref_referenced_sequence_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_ref_referenced_sequence_decode(
    struct uper_c_ref_referenced_sequence_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_ref_referenced_sequence_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_ref_referenced_enum_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_ref_referenced_enum_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_ref_referenced_enum_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_ref_referenced_enum_decode(
    struct uper_c_ref_referenced_enum_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_ref_referenced_enum_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ap_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ap_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ap_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ap_decode(
    struct uper_c_source_ap_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ap_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_aq_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_aq_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_aq_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_aq_decode(
    struct uper_c_source_aq_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_aq_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_ar_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_ar_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_ar_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_ar_decode(
    struct uper_c_source_ar_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_ar_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_as_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_as_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_as_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_as_decode(
    struct uper_c_source_as_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_as_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_ref_at_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_ref_at_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_ref_at_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_ref_at_decode(
    struct uper_c_ref_at_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_ref_at_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_ref_au_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_ref_au_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_ref_au_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_ref_au_decode(
    struct uper_c_ref_au_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_ref_au_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_b_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_b_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_b_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_b_decode(
    struct uper_c_source_b_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_b_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_c_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_c_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_c_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_c_decode(
    struct uper_c_source_c_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_c_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_e_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_e_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_e_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_e_decode(
    struct uper_c_source_e_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_e_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_f_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_f_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_f_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_f_decode(
    struct uper_c_source_f_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_f_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_g_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_g_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_g_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_g_decode(
    struct uper_c_source_g_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_g_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_h_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_h_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_h_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_h_decode(
    struct uper_c_source_h_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_h_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_i_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_i_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_i_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_i_decode(
    struct uper_c_source_i_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_i_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_j_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_j_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_j_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_j_decode(
    struct uper_c_source_j_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_j_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_k_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_k_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_k_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_k_decode(
    struct uper_c_source_k_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_k_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_l_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_l_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_l_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_l_decode(
    struct uper_c_source_l_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_l_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_o_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_o_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_o_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_o_decode(
    struct uper_c_source_o_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_o_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_n_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_n_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_n_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_n_decode(
    struct uper_c_source_n_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_n_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_m_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_m_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_m_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_m_decode(
    struct uper_c_source_m_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_m_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_p_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_p_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_p_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_p_decode(
    struct uper_c_source_p_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_p_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_r_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_r_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_r_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_r_decode(
    struct uper_c_source_r_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_r_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_ref_referenced_int_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_ref_referenced_int_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_ref_referenced_int_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_ref_referenced_int_decode(
    struct uper_c_ref_referenced_int_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_ref_referenced_int_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_s_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_s_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_s_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_s_decode(
    struct uper_c_source_s_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_s_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_t_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_t_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_t_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_t_decode(
    struct uper_c_source_t_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_t_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_u_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_u_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_u_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_u_decode(
    struct uper_c_source_u_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_u_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_v_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_v_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_v_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_v_decode(
    struct uper_c_source_v_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_v_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_w_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_w_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_w_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_w_decode(
    struct uper_c_source_w_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_w_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_x_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_x_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_x_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_x_decode(
    struct uper_c_source_x_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_x_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_y_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_y_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_y_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_y_decode(
    struct uper_c_source_y_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_y_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t uper_c_source_z_encode(
    uint8_t *dst_p,
    size_t size,
    const struct uper_c_source_z_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    uper_c_source_z_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t uper_c_source_z_decode(
    struct uper_c_source_z_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    uper_c_source_z_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}
