/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.Binding;
import android.databinding.tool.BindingTarget;
import android.databinding.tool.ExpressionParser;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.IdentifierExpr;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.writer.LayoutBinderWriter;
import android.databinding.tool.writer.WriterPackage;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayoutBinder {
    private static final Comparator<BindingTarget> COMPARE_FIELD_NAME = new Comparator<BindingTarget>(){

        @Override
        public int compare(BindingTarget first, BindingTarget second) {
            String fieldName1 = WriterPackage.getFieldName(first);
            String fieldName2 = WriterPackage.getFieldName(second);
            return fieldName1.compareTo(fieldName2);
        }
    };
    private final ExprModel mExprModel;
    private final ExpressionParser mExpressionParser;
    private final List<BindingTarget> mBindingTargets;
    private final List<BindingTarget> mSortedBindingTargets;
    private String mModulePackage;
    private final HashMap<String, String> mUserDefinedVariables = new HashMap();
    private LayoutBinderWriter mWriter;
    private ResourceBundle.LayoutFileBundle mBundle;
    private static final String[] sJavaLangClasses = new String[]{"Deprecated", "Override", "SafeVarargs", "SuppressWarnings", "Appendable", "AutoCloseable", "CharSequence", "Cloneable", "Comparable", "Iterable", "Readable", "Runnable", "Thread.UncaughtExceptionHandler", "Boolean", "Byte", "Character", "Character.Subset", "Character.UnicodeBlock", "Class", "ClassLoader", "Compiler", "Double", "Enum", "Float", "InheritableThreadLocal", "Integer", "Long", "Math", "Number", "Object", "Package", "Process", "ProcessBuilder", "Runtime", "RuntimePermission", "SecurityManager", "Short", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "System", "Thread", "ThreadGroup", "ThreadLocal", "Throwable", "Void", "Thread.State", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "ClassCastException", "ClassNotFoundException", "CloneNotSupportedException", "EnumConstantNotPresentException", "Exception", "IllegalAccessException", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IndexOutOfBoundsException", "InstantiationException", "InterruptedException", "NegativeArraySizeException", "NoSuchFieldException", "NoSuchMethodException", "NullPointerException", "NumberFormatException", "ReflectiveOperationException", "RuntimeException", "SecurityException", "StringIndexOutOfBoundsException", "TypeNotPresentException", "UnsupportedOperationException", "AbstractMethodError", "AssertionError", "ClassCircularityError", "ClassFormatError", "Error", "ExceptionInInitializerError", "IllegalAccessError", "IncompatibleClassChangeError", "InstantiationError", "InternalError", "LinkageError", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchMethodError", "OutOfMemoryError", "StackOverflowError", "ThreadDeath", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "VerifyError", "VirtualMachineError"};

    public LayoutBinder(ResourceBundle.LayoutFileBundle layoutBundle) {
        this.mExprModel = new ExprModel();
        this.mExpressionParser = new ExpressionParser(this.mExprModel);
        this.mBindingTargets = new ArrayList<BindingTarget>();
        this.mBundle = layoutBundle;
        this.mModulePackage = layoutBundle.getModulePackage();
        for (Map.Entry<String, String> variable : this.mBundle.getVariables().entrySet()) {
            this.addVariable(variable.getKey(), variable.getValue());
        }
        for (Map.Entry<String, String> userImport : this.mBundle.getImports().entrySet()) {
            this.mExprModel.addImport(userImport.getKey(), userImport.getValue());
        }
        for (String javaLangClass : sJavaLangClasses) {
            this.mExprModel.addImport(javaLangClass, "java.lang." + javaLangClass);
        }
        for (ResourceBundle.BindingTargetBundle targetBundle : this.mBundle.getBindingTargetBundles()) {
            BindingTarget bindingTarget = this.createBindingTarget(targetBundle);
            for (ResourceBundle.BindingTargetBundle.BindingBundle bindingBundle : targetBundle.getBindingBundleList()) {
                bindingTarget.addBinding(bindingBundle.getName(), this.parse(bindingBundle.getExpr()));
            }
            bindingTarget.resolveMultiSetters();
        }
        this.mSortedBindingTargets = new ArrayList<BindingTarget>(this.mBindingTargets);
        Collections.sort(this.mSortedBindingTargets, COMPARE_FIELD_NAME);
    }

    public void resolveWhichExpressionsAreUsed() {
        ArrayList<Expr> used = new ArrayList<Expr>();
        for (BindingTarget target : this.mBindingTargets) {
            for (Binding binding : target.getBindings()) {
                binding.getExpr().setIsUsed(true);
                used.add(binding.getExpr());
            }
        }
        while (!used.isEmpty()) {
            Expr e = (Expr)used.remove(used.size() - 1);
            for (Dependency dep : e.getDependencies()) {
                if (dep.getOther().isUsed()) continue;
                used.add(dep.getOther());
                dep.getOther().setIsUsed(true);
            }
        }
    }

    public IdentifierExpr addVariable(String name, String type) {
        Preconditions.checkState(!this.mUserDefinedVariables.containsKey(name), "%s has already been defined as %s", name, type);
        IdentifierExpr id = this.mExprModel.identifier(name);
        id.setUserDefinedType(type);
        id.enableDirectInvalidation();
        this.mUserDefinedVariables.put(name, type);
        return id;
    }

    public HashMap<String, String> getUserDefinedVariables() {
        return this.mUserDefinedVariables;
    }

    public BindingTarget createBindingTarget(ResourceBundle.BindingTargetBundle targetBundle) {
        BindingTarget target = new BindingTarget(targetBundle);
        this.mBindingTargets.add(target);
        target.setModel(this.mExprModel);
        return target;
    }

    public Expr parse(String input) {
        Expr parsed = this.mExpressionParser.parse(input);
        parsed.setBindingExpression(true);
        return parsed;
    }

    public List<BindingTarget> getBindingTargets() {
        return this.mBindingTargets;
    }

    public List<BindingTarget> getSortedTargets() {
        return this.mSortedBindingTargets;
    }

    public boolean isEmpty() {
        return this.mExprModel.size() == 0;
    }

    public ExprModel getModel() {
        return this.mExprModel;
    }

    private void ensureWriter() {
        if (this.mWriter == null) {
            this.mWriter = new LayoutBinderWriter(this);
        }
    }

    public String writeViewBinderBaseClass() {
        this.ensureWriter();
        return this.mWriter.writeBaseClass();
    }

    public String writeViewBinder(int minSdk) {
        this.mExprModel.seal();
        this.ensureWriter();
        Preconditions.checkNotNull(this.getPackage(), "package cannot be null");
        Preconditions.checkNotNull(this.getClassName(), "base class name cannot be null");
        return this.mWriter.write(minSdk);
    }

    public String getPackage() {
        return this.mBundle.getBindingClassPackage();
    }

    public boolean isMerge() {
        return this.mBundle.isMerge();
    }

    public String getModulePackage() {
        return this.mModulePackage;
    }

    public String getLayoutname() {
        return this.mBundle.getFileName();
    }

    public String getImplementationName() {
        if (this.hasVariations()) {
            return this.mBundle.getBindingClassName() + this.mBundle.getConfigName() + "Impl";
        }
        return this.mBundle.getBindingClassName();
    }

    public String getClassName() {
        return this.mBundle.getBindingClassName();
    }

    public String getTag() {
        return this.mBundle.getDirectory() + "/" + this.mBundle.getFileName();
    }

    public boolean hasVariations() {
        return this.mBundle.hasVariations();
    }
}

